/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.etlserver.DataSetMover;
import ch.systemsx.cisd.etlserver.IDataSetInfoExtractor;
import ch.systemsx.cisd.etlserver.IETLServerPlugin;
import ch.systemsx.cisd.etlserver.IProcedureAndDataTypeExtractor;
import ch.systemsx.cisd.etlserver.IStorageProcessor;
import java.io.File;

public class ETLServerPlugin
implements IETLServerPlugin {
    private final IDataSetInfoExtractor codeExtractor;
    private final IProcedureAndDataTypeExtractor typeExtractor;
    private final IStorageProcessor storageProcessor;
    private final DataSetMover mover;

    public ETLServerPlugin(IDataSetInfoExtractor codeExtractor, IProcedureAndDataTypeExtractor typeExtractor, IStorageProcessor storageProcessor, DataSetMover mover) {
        assert (codeExtractor != null) : "Missing code extractor";
        assert (typeExtractor != null) : "Missing type extractor";
        assert (storageProcessor != null) : "Missing storage processor";
        assert (mover != null) : "Missing data set mover.";
        this.codeExtractor = codeExtractor;
        this.typeExtractor = typeExtractor;
        this.storageProcessor = storageProcessor;
        this.mover = mover;
    }

    public final IDataSetInfoExtractor getDataSetInfoExtractor() {
        return this.codeExtractor;
    }

    public final IProcedureAndDataTypeExtractor getTypeExtractor() {
        return this.typeExtractor;
    }

    public final IStorageProcessor getStorageProcessor() {
        return this.storageProcessor;
    }

    public boolean moveDataSetAndLog(File incomingDataSetFile, File targetFile) {
        return this.mover.moveDataSetAndLog(incomingDataSetFile, targetFile);
    }
}

