/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.DataSetInformation;
import ch.systemsx.cisd.etlserver.DataStoreStrategyKey;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ObservableType;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IdentifiedDataStrategy
implements IDataStoreStrategy {
    static final String UNEXPECTED_PATHS_MSG_FORMAT = "There are unexpected paths '%s' in data store '%s'. I'll proceed anyway.";
    private static final NumberedFileComparator NUMBERED_FILE_COMPARATOR = new NumberedFileComparator();
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, IdentifiedDataStrategy.class);

    IdentifiedDataStrategy() {
    }

    private static String createInstanceDirectory(DataSetInformation dataSetInfo) {
        String instanceCode = dataSetInfo.getInstanceCode();
        assert (instanceCode != null) : "Instance code can not be null.";
        return "Instance_" + instanceCode;
    }

    private static String createGroupDirectory(DataSetInformation dataSetInfo) {
        ExperimentIdentifier identifier = dataSetInfo.getExperimentIdentifier();
        assert (identifier != null) : "Identifier can not be null.";
        String groupCode = identifier.getGroupCode();
        assert (groupCode != null) : "Group code can not be null.";
        return "Group_" + groupCode;
    }

    private static String createProjectDirectory(DataSetInformation dataSetInfo) {
        ExperimentIdentifier identifier = dataSetInfo.getExperimentIdentifier();
        assert (identifier != null) : "Identifier can not be null.";
        String projectCode = identifier.getProjectCode();
        assert (projectCode != null) : "Project code can not be null.";
        return "Project_" + projectCode;
    }

    private static String createExperimentDirectory(DataSetInformation dataSetInfo) {
        ExperimentIdentifier identifier = dataSetInfo.getExperimentIdentifier();
        assert (identifier != null) : "Identifier can not be null.";
        String experimentCode = identifier.getExperimentCode();
        assert (experimentCode != null) : "Experiment code can not be null.";
        return "Experiment_" + experimentCode;
    }

    private static final String createBarcodeDirectory(DataSetInformation dataSetInfo) {
        String sampleCode = dataSetInfo.getSampleCode();
        assert (sampleCode != null) : "Sample code can not be null.";
        return "Barcode_" + sampleCode;
    }

    static final String createObservableTypeDirectory(ObservableType observableType) {
        String observableTypeCode = observableType.getCode();
        assert (observableTypeCode != null) : "Observable type code can not be null.";
        return "ObservableType_" + observableTypeCode;
    }

    private static final File createBaseDirectory(File baseDir, DataSetInformation dataSetInfo, ObservableType observableType) {
        File instanceDir = new File(baseDir, IdentifiedDataStrategy.createInstanceDirectory(dataSetInfo));
        File groupDir = new File(instanceDir, IdentifiedDataStrategy.createGroupDirectory(dataSetInfo));
        File projectDir = new File(groupDir, IdentifiedDataStrategy.createProjectDirectory(dataSetInfo));
        File experimentDir = new File(projectDir, IdentifiedDataStrategy.createExperimentDirectory(dataSetInfo));
        File observableTypeDir = new File(experimentDir, IdentifiedDataStrategy.createObservableTypeDirectory(observableType));
        return new File(observableTypeDir, IdentifiedDataStrategy.createBarcodeDirectory(dataSetInfo));
    }

    static final int getNextNumberedDir(File baseDir, String[] fileNames) {
        assert (fileNames.length > 0) : "Do not call this method will no file names.";
        Set<String> unexpectedPaths = IdentifiedDataStrategy.checkFileNames(fileNames);
        ArrayList fileNamesList = new ArrayList(Arrays.asList(fileNames));
        fileNamesList.removeAll(unexpectedPaths);
        Collections.sort(fileNamesList, NUMBERED_FILE_COMPARATOR);
        int size = fileNamesList.size();
        String latestDataSet = size > 0 ? (String)fileNamesList.get(size - 1) : "0";
        if (!unexpectedPaths.isEmpty()) {
            operationLog.warn(String.format(UNEXPECTED_PATHS_MSG_FORMAT, unexpectedPaths, baseDir));
        }
        return Integer.parseInt(latestDataSet) + 1;
    }

    private static final Set<String> checkFileNames(String[] fileNames) {
        TreeSet<String> unexpectedPaths = new TreeSet<String>();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (!NumberUtils.isDigits((String)fileName)) {
                unexpectedPaths.add(fileName);
            }
            ++n2;
        }
        return unexpectedPaths;
    }

    @Override
    public final DataStoreStrategyKey getKey() {
        return DataStoreStrategyKey.IDENTIFIED;
    }

    @Override
    public final File getBaseDirectory(File storeRoot, DataSetInformation dataSetInfo, ObservableType observableType) {
        assert (storeRoot != null) : "Store root can not be null";
        assert (dataSetInfo != null) : "Data set information can not be null";
        assert (observableType != null) : "Observable type can not be null";
        File baseDirectory = IdentifiedDataStrategy.createBaseDirectory(storeRoot, dataSetInfo, observableType);
        int dataSetNumber = 1;
        if (baseDirectory.exists()) {
            String[] dataSets = baseDirectory.list();
            if (dataSets == null) {
                throw EnvironmentFailureException.fromTemplate("Serious error in data store layout: path '%s' is supposed to be a directory, but isn't.", baseDirectory.getAbsolutePath());
            }
            if (dataSets.length > 0) {
                dataSetNumber = IdentifiedDataStrategy.getNextNumberedDir(baseDirectory, dataSets);
            }
        }
        return new File(baseDirectory, Integer.toString(dataSetNumber));
    }

    @Override
    public final File getTargetPath(File baseDirectory, File incomingDataSetPath) throws IllegalStateException {
        assert (baseDirectory != null) : "Base directory can not be null";
        assert (incomingDataSetPath != null) : "Incoming data set can not be null";
        File targetPath = new File(baseDirectory, incomingDataSetPath.getName());
        if (targetPath.exists()) {
            throw new IllegalStateException(String.format("Target path '%s' of identified incoming data set already exists (which it shouldn't), bailing out.", targetPath.getAbsolutePath()));
        }
        return targetPath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NumberedFileComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        NumberedFileComparator() {
        }

        private static final void checkString(String o1) {
            assert (NumberUtils.isDigits((String)o1)) : String.format("Given string '%s' is not a digit.", o1);
        }

        @Override
        public final int compare(String o1, String o2) {
            NumberedFileComparator.checkString(o1);
            NumberedFileComparator.checkString(o2);
            return Integer.parseInt(o1) - Integer.parseInt(o2);
        }
    }
}

