/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.utilities.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.common.utilities.DirectoryScanningTimerTask;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.ISelfTestable;
import ch.systemsx.cisd.common.utilities.NamePrefixFileFilter;
import ch.systemsx.cisd.common.utilities.PropertyUtils;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.etlserver.EncapsulatedLimsService;
import ch.systemsx.cisd.etlserver.IETLServerPlugin;
import ch.systemsx.cisd.etlserver.IEncapsulatedLimsService;
import ch.systemsx.cisd.etlserver.IProcessorFactory;
import ch.systemsx.cisd.etlserver.Parameters;
import ch.systemsx.cisd.etlserver.StandardProcessorFactory;
import ch.systemsx.cisd.etlserver.ThreadParameters;
import ch.systemsx.cisd.etlserver.TransferredDataSetHandler;
import ch.systemsx.cisd.lims.base.IETLLIMSService;
import ch.systemsx.cisd.lims.base.RMIBasedLIMSServiceFactory;
import ch.systemsx.cisd.lims.base.ServiceRegistry;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main {
    static final String INSTANCE_CODE_KEY = "instance-code";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, Main.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, Main.class);
    private static final Thread.UncaughtExceptionHandler loggingExceptionHandler = new Thread.UncaughtExceptionHandler(){

        public void uncaughtException(Thread t, Throwable e) {
            notificationLog.error("An exception has occurred [thread: '" + t.getName() + "'].", e);
        }
    };
    static IExitHandler exitHandler = SystemExit.SYSTEM_EXIT;

    private static void initLog() {
        LogInitializer.init();
        Thread.setDefaultUncaughtExceptionHandler(loggingExceptionHandler);
    }

    private static void printInitialLogMessage(Parameters parameters) {
        operationLog.info("Etlserver is starting up.");
        for (String line : BuildAndEnvironmentInfo.INSTANCE.getEnvironmentInfo()) {
            operationLog.info(line);
        }
        parameters.log();
    }

    private static void selfTest(File incomingDirectory, IEncapsulatedLimsService service, ISelfTestable ... selfTestables) {
        try {
            Main.checkFullyAccesible(incomingDirectory);
            int serviceVersion = service.getVersion();
            if (17 != serviceVersion) {
                throw new ConfigurationFailureException("This client has the wrong service version for the server (client: 17, server: " + serviceVersion + ").");
            }
            ISelfTestable[] iSelfTestableArray = selfTestables;
            int n = selfTestables.length;
            int n2 = 0;
            while (n2 < n) {
                ISelfTestable selfTestable = iSelfTestableArray[n2];
                selfTestable.check();
                ++n2;
            }
        }
        catch (HighLevelException e) {
            System.err.printf("Etlserver self test failed: [%s: %s]\n", e.getClass().getSimpleName(), e.getMessage());
            exitHandler.exit(1);
        }
        catch (RuntimeException e) {
            System.err.println("Etlserver self test failed:");
            e.printStackTrace();
            exitHandler.exit(1);
        }
    }

    private static void checkFullyAccesible(File directory) throws ConfigurationFailureException {
        String errorMessage;
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("Checking source directory '" + directory.getAbsolutePath() + "'.");
        }
        if ((errorMessage = FileUtilities.checkDirectoryFullyAccessible(directory, "source")) != null) {
            throw new ConfigurationFailureException(errorMessage);
        }
    }

    private static IETLLIMSService getETLLIMSService(Parameters parameters) {
        String serviceURL = Main.getServiceURL(parameters);
        IETLLIMSService service = ServiceRegistry.getLIMSServiceFactory().createETLLIMSService(serviceURL);
        return service;
    }

    private static String getServiceURL(Parameters parameters) {
        String serverURL = parameters.getServerURL();
        if (serverURL == null) {
            throw new EnvironmentFailureException("Application Server URL is not defined.");
        }
        return serverURL;
    }

    private static void startupServer(Parameters parameters) {
        LinkedHashMap<String, IProcessorFactory> processorFactories = new LinkedHashMap<String, IProcessorFactory>();
        Map<String, Properties> processorProperties = parameters.getProcessorProperties();
        for (Map.Entry<String, Properties> entry : processorProperties.entrySet()) {
            processorFactories.put(entry.getKey(), StandardProcessorFactory.create(entry.getValue()));
        }
        ThreadParameters[] threads = parameters.getThreads();
        IEncapsulatedLimsService authorizedLimsService = Main.createAuthorizedLimsService(parameters);
        ThreadParameters[] threadParametersArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadParameters threadParameters = threadParametersArray[n2];
            Main.createProcessingThread(parameters, threadParameters, authorizedLimsService, processorFactories);
            ++n2;
        }
    }

    private static IEncapsulatedLimsService createAuthorizedLimsService(Parameters parameters) {
        String username = parameters.getUsername();
        String password = parameters.getPassword();
        IETLLIMSService limsService = Main.getETLLIMSService(parameters);
        return new EncapsulatedLimsService(limsService, username, password);
    }

    private static void createProcessingThread(Parameters parameters, ThreadParameters threadParameters, IEncapsulatedLimsService authorizedLimsService, Map<String, IProcessorFactory> processorFactories) {
        File incomingDataDirectory = threadParameters.getIncomingDataDirectory();
        IETLServerPlugin plugin = threadParameters.getPlugin();
        String instanceCode = PropertyUtils.getMandatoryProperty(parameters.getProperties(), INSTANCE_CODE_KEY);
        Properties mailProperties = parameters.getMailProperties();
        TransferredDataSetHandler mover = new TransferredDataSetHandler(instanceCode, plugin, authorizedLimsService, mailProperties);
        mover.setProcessorFactories(processorFactories);
        DirectoryScanningTimerTask dataMonitorTask = new DirectoryScanningTimerTask(incomingDataDirectory, new NamePrefixFileFilter(".MARKER_is_finished_", true), mover);
        Main.selfTest(incomingDataDirectory, authorizedLimsService, mover);
        String timerThreadName = String.valueOf(threadParameters.getThreadName()) + " - Incoming Data Monitor";
        Timer incomingDataMovingTimer = new Timer(timerThreadName);
        incomingDataMovingTimer.schedule((TimerTask)dataMonitorTask, 0L, parameters.getCheckIntervalMillis());
    }

    public static void main(String[] args) {
        ServiceRegistry.setLIMSServiceFactory(RMIBasedLIMSServiceFactory.INSTANCE);
        Main.initLog();
        Parameters parameters = new Parameters(args);
        Main.printInitialLogMessage(parameters);
        Main.startupServer(parameters);
        operationLog.info("etlserver ready and waiting for data.");
    }
}

