/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.utilities.PathPrefixPrepender;
import ch.systemsx.cisd.common.utilities.PropertyUtils;
import ch.systemsx.cisd.etlserver.FileBasedFileFactory;
import ch.systemsx.cisd.etlserver.IFileFactory;
import ch.systemsx.cisd.etlserver.IProcessor;
import ch.systemsx.cisd.etlserver.IProcessorFactory;
import ch.systemsx.cisd.etlserver.StandardProcessor;
import ch.systemsx.cisd.lims.base.util.StorageFormat;
import java.util.Properties;

public class StandardProcessorFactory
implements IProcessorFactory {
    private static final String HARD_LINK_INSTEAD_OF_COPY_KEY = "hard-link-instead-of-copy";
    private static final String PATH_PREFIX_ABSOLUTE_KEY = "prefix-for-absolute-paths";
    private static final String PATH_PREFIX_RELATIVE_KEY = "prefix-for-relative-paths";
    private static final String PARAMETERS_FILE_KEY = "parameters-file";
    private static final String INPUT_STORAGE_FORMAT_KEY = "input-storage-format";
    private static final String DATA_SET_CODE_PREFIX_GLUE_KEY = "data-set-code-prefix-glue";
    private static final String FINISHED_FILE_TEMPLATE_KEY = "finished-file-template";
    private static final String DATA_COPY_TIMEOUT = "data-copy-timeout";
    private static final int DEFAULT_DATA_COPY_TIMEOUT_SEC = 0;
    private final String parametersFileName;
    private final String finishedFileNameTemplate;
    private final IFileFactory fileFactory;
    private final StorageFormat inputStorageFormat;
    private final PathPrefixPrepender pathPrefixPrepender;
    private final String dataSetCodePrefixGlueCharacter;

    public static StandardProcessorFactory create(Properties properties) throws ConfigurationFailureException {
        FileBasedFileFactory fileBasedFileFactory = StandardProcessorFactory.createFileFactory(properties);
        return new StandardProcessorFactory(properties, fileBasedFileFactory);
    }

    private static FileBasedFileFactory createFileFactory(Properties properties) throws ConfigurationFailureException {
        long millisToWaitForCopyCompletion = PropertyUtils.getInt(properties, DATA_COPY_TIMEOUT, 0) * 1000;
        boolean useHardLinks = PropertyUtils.getBoolean(properties, HARD_LINK_INSTEAD_OF_COPY_KEY, true);
        FileBasedFileFactory fileBasedFileFactory = new FileBasedFileFactory(useHardLinks, millisToWaitForCopyCompletion);
        return fileBasedFileFactory;
    }

    private StandardProcessorFactory(Properties properties, IFileFactory fileFactory) throws ConfigurationFailureException {
        this.fileFactory = fileFactory;
        assert (properties != null) : "Undefined properties.";
        String prefixForAbsolutePathsOrNull = properties.getProperty(PATH_PREFIX_ABSOLUTE_KEY);
        String prefixForRelativePathsOrNull = properties.getProperty(PATH_PREFIX_RELATIVE_KEY);
        String inputDataFormatCode = PropertyUtils.getMandatoryProperty(properties, INPUT_STORAGE_FORMAT_KEY);
        this.inputStorageFormat = StorageFormat.tryGetFromCode(inputDataFormatCode);
        if (this.inputStorageFormat == null) {
            throw ConfigurationFailureException.fromTemplate("input-storage-format property has illegal value '%s'.", inputDataFormatCode);
        }
        this.pathPrefixPrepender = new PathPrefixPrepender(prefixForAbsolutePathsOrNull, prefixForRelativePathsOrNull);
        this.parametersFileName = PropertyUtils.getMandatoryProperty(properties, PARAMETERS_FILE_KEY);
        this.finishedFileNameTemplate = PropertyUtils.getMandatoryProperty(properties, FINISHED_FILE_TEMPLATE_KEY);
        this.dataSetCodePrefixGlueCharacter = PropertyUtils.getMandatoryProperty(properties, DATA_SET_CODE_PREFIX_GLUE_KEY);
    }

    public final IProcessor createProcessor() {
        return new StandardProcessor(this.fileFactory, this.inputStorageFormat, this.pathPrefixPrepender, this.parametersFileName, this.finishedFileNameTemplate, this.dataSetCodePrefixGlueCharacter);
    }
}

