/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.imsb;

import ch.systemsx.cisd.bds.hcs.Channel;
import ch.systemsx.cisd.bds.hcs.Geometry;
import ch.systemsx.cisd.bds.hcs.Location;
import ch.systemsx.cisd.bds.hcs.WellGeometry;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.ChannelSetHelper;
import ch.systemsx.cisd.etlserver.DataSetInformation;
import ch.systemsx.cisd.etlserver.HCSImageFileExtractionResult;
import ch.systemsx.cisd.etlserver.IHCSImageFileAccepter;
import ch.systemsx.cisd.etlserver.IHCSImageFileExtractor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HCSImageFileExtractor
implements IHCSImageFileExtractor {
    private static final String TIFF_SUBDIRECTORY = "TIFF";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, HCSImageFileExtractor.class);
    static final String IMAGE_FILE_NOT_STANDARDIZABLE = "Image file '%s' could not be standardized given following tokens [plateLocation=%s,wellLocation=%s,channel=%s].";
    static final String IMAGE_FILE_NOT_ENOUGH_ENTITIES = "Image file '%s' does not have enough entities.";
    static final String IMAGE_FILE_BELONGS_TO_WRONG_SAMPLE = "Image file '%s' belongs to the wrong sample [expected=%s,found=%s].";
    static final String IMAGE_FILE_ACCEPTED = "Image file '%s' was accepted for channel %d, plate location %s and well location %s.";
    static final char TOKEN_SEPARATOR = '_';
    private final Geometry wellGeometry;

    public HCSImageFileExtractor(Properties properties) {
        assert (properties != null) : "Given properites should not be null";
        this.wellGeometry = HCSImageFileExtractor.getWellGeometry(properties);
    }

    private static final Geometry getWellGeometry(Properties properties) {
        String property = properties.getProperty("well_geometry");
        if (property == null) {
            throw new ConfigurationFailureException(String.format("No '%s' property has been specified.", "well_geometry"));
        }
        Geometry geometry = WellGeometry.createFromString(property);
        if (geometry == null) {
            throw new ConfigurationFailureException(String.format("Could not create a geometry from property value '%s'.", property));
        }
        return geometry;
    }

    private final Location tryGetWellLocation(String value) {
        try {
            return Location.tryCreateLocationFromPosition(Integer.parseInt(value), this.wellGeometry);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static final Location tryGetPlateLocation(String value) {
        return Location.tryCreateLocationFromMatrixCoordinate(value);
    }

    private final int getChannelWavelength(String value) {
        if (value.startsWith("w")) {
            try {
                return Integer.parseInt(value.substring("w".length()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    Collection<File> listFiles(File incomingDataSetDirectory) {
        try {
            return FileUtils.listFiles((File)incomingDataSetDirectory, (String[])new String[]{"tif", "tiff"}, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().equals("Parameter 'directory' is not a directory")) {
                throw new ConfigurationFailureException("Incoming data set directory '" + incomingDataSetDirectory.getAbsolutePath() + "' isn't a directory.");
            }
            throw e;
        }
    }

    @Override
    public final HCSImageFileExtractionResult process(File incomingDataSetDirectory, DataSetInformation dataSetInformation, IHCSImageFileAccepter accepter) {
        assert (incomingDataSetDirectory != null);
        this.checkIncomingDirectory(incomingDataSetDirectory);
        Collection<File> imageFiles = this.listFiles(new File(incomingDataSetDirectory, TIFF_SUBDIRECTORY));
        long start = System.currentTimeMillis();
        ArrayList<File> invalidFiles = new ArrayList<File>();
        ChannelWavelengthSortingHCSImageFileAccepterDecorator accepterDecorator = new ChannelWavelengthSortingHCSImageFileAccepterDecorator(accepter);
        for (File imageFile : imageFiles) {
            String baseName;
            String[] tokens;
            if (operationLog.isDebugEnabled()) {
                operationLog.debug(String.format("Processing image file '%s'", imageFile));
            }
            if ((tokens = StringUtils.split((String)(baseName = FilenameUtils.getBaseName((String)imageFile.getPath())), (char)'_')).length < 4) {
                if (operationLog.isDebugEnabled()) {
                    operationLog.debug(String.format(IMAGE_FILE_NOT_ENOUGH_ENTITIES, imageFile));
                }
                invalidFiles.add(imageFile);
                continue;
            }
            String sampleCode = tokens[tokens.length - 4];
            if (!dataSetInformation.getSampleCode().equals(sampleCode)) {
                if (operationLog.isDebugEnabled()) {
                    operationLog.debug(String.format(IMAGE_FILE_BELONGS_TO_WRONG_SAMPLE, imageFile, dataSetInformation.getSampleCode(), sampleCode));
                }
                invalidFiles.add(imageFile);
                continue;
            }
            String plateLocationStr = tokens[tokens.length - 3];
            Location plateLocation = HCSImageFileExtractor.tryGetPlateLocation(plateLocationStr);
            String wellLocationStr = tokens[tokens.length - 2];
            Location wellLocation = this.tryGetWellLocation(wellLocationStr);
            String channelStr = tokens[tokens.length - 1];
            int channelWavelength = this.getChannelWavelength(channelStr);
            if (wellLocation != null && plateLocation != null && channelWavelength > 0) {
                accepterDecorator.accept(channelWavelength, plateLocation, wellLocation, imageFile);
                if (!operationLog.isDebugEnabled()) continue;
                operationLog.debug(String.format(IMAGE_FILE_ACCEPTED, imageFile, channelWavelength, plateLocation, wellLocation));
                continue;
            }
            if (operationLog.isDebugEnabled()) {
                operationLog.debug(String.format(IMAGE_FILE_NOT_STANDARDIZABLE, imageFile, plateLocationStr, wellLocationStr, channelStr));
            }
            invalidFiles.add(imageFile);
        }
        accepterDecorator.commit();
        return new HCSImageFileExtractionResult(System.currentTimeMillis() - start, imageFiles.size(), Collections.unmodifiableList(invalidFiles), accepterDecorator.getChannels());
    }

    private void checkIncomingDirectory(File incomingDataSetDirectory) {
        if (!incomingDataSetDirectory.isDirectory()) {
            throw UserFailureException.fromTemplate("Given incoming data set '%s' must be a directory.", incomingDataSetDirectory.getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChannelWavelengthSortingHCSImageFileAccepterDecorator
    implements IHCSImageFileAccepter {
        private final IHCSImageFileAccepter accepter;
        private final List<ImageFileRecord> images = new ArrayList<ImageFileRecord>();
        private final ChannelSetHelper helper;

        ChannelWavelengthSortingHCSImageFileAccepterDecorator(IHCSImageFileAccepter accepter) {
            this.accepter = accepter;
            this.helper = new ChannelSetHelper();
        }

        final Set<Channel> getChannels() {
            return this.helper.getChannelSet();
        }

        final void commit() {
            for (ImageFileRecord image : this.images) {
                this.accepter.accept(this.helper.getChannelForWavelength(image.channelWavelength).getCounter(), image.plateLocation, image.wellLocation, image.imageFile);
            }
        }

        @Override
        public final void accept(int channelWavelength, Location wellLocation, Location tileLocation, File imageFile) {
            this.images.add(new ImageFileRecord(imageFile, wellLocation, tileLocation, channelWavelength));
            this.helper.addWavelength(channelWavelength);
        }
    }

    private static class ImageFileRecord {
        final File imageFile;
        final Location plateLocation;
        final Location wellLocation;
        final int channelWavelength;

        ImageFileRecord(File imageFile, Location plateLocation, Location wellLocation, int channelWavelength) {
            this.imageFile = imageFile;
            this.plateLocation = plateLocation;
            this.wellLocation = wellLocation;
            this.channelWavelength = channelWavelength;
        }
    }
}

