/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.threev;

import ch.systemsx.cisd.bds.hcs.Geometry;
import ch.systemsx.cisd.bds.hcs.Location;
import ch.systemsx.cisd.bds.hcs.WellGeometry;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.ChannelSetHelper;
import ch.systemsx.cisd.etlserver.DataSetInformation;
import ch.systemsx.cisd.etlserver.HCSImageFileExtractionResult;
import ch.systemsx.cisd.etlserver.IHCSImageFileAccepter;
import ch.systemsx.cisd.etlserver.IHCSImageFileExtractor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HCSImageFileExtractor
implements IHCSImageFileExtractor {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, HCSImageFileExtractor.class);
    static final String IMAGE_FILE_NOT_STANDARDIZABLE = "Image file '%s' could not be standardized given following tokens [plateLocation=%s,wellLocation=%s,channel=%s].";
    static final String IMAGE_FILE_ACCEPTED = "Image file '%s' was accepted for channel %d, plate location %s and well location %s.";
    static final String FILE_PREFIX = "Screening_";
    static final int TOKEN_NUMBER = 5;
    static final char TOKEN_SEPARATOR = '_';
    private final Geometry wellGeometry;

    public HCSImageFileExtractor(Properties properties) {
        assert (properties != null) : "Given properites should not be null";
        this.wellGeometry = HCSImageFileExtractor.getWellGeometry(properties);
    }

    private static final Geometry getWellGeometry(Properties properties) {
        String property = properties.getProperty("well_geometry");
        if (property == null) {
            throw new ConfigurationFailureException(String.format("No '%s' property has been specified.", "well_geometry"));
        }
        Geometry geometry = WellGeometry.createFromString(property);
        if (geometry == null) {
            throw new ConfigurationFailureException(String.format("Could not create a geometry from property value '%s'.", property));
        }
        return geometry;
    }

    private final Location tryGetWellLocation(String value) {
        if (value.startsWith("s")) {
            String tileNo = value.substring("s".length());
            try {
                return Location.tryCreateLocationFromPosition(Integer.parseInt(tileNo), this.wellGeometry);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    private static final Location tryGetPlateLocation(String value) {
        return Location.tryCreateLocationFromMatrixCoordinate(value);
    }

    private final int getWavelength(String value) {
        if (value.startsWith("w")) {
            try {
                return Integer.parseInt(value.substring("w".length()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    private Collection<File> listFiles(File incomingDataSetDirectory) {
        Collection imageFiles = FileUtils.listFiles((File)incomingDataSetDirectory, (String[])new String[]{"tif", "tiff"}, (boolean)true);
        return imageFiles;
    }

    @Override
    public final HCSImageFileExtractionResult process(File incomingDataSetDirectory, DataSetInformation dataSetInformation, IHCSImageFileAccepter accepter) {
        assert (incomingDataSetDirectory != null);
        this.checkIncomingDirectory(incomingDataSetDirectory);
        Collection<File> imageFiles = this.listFiles(incomingDataSetDirectory);
        long start = System.currentTimeMillis();
        ArrayList<File> invalidFiles = new ArrayList<File>();
        ChannelSetHelper helper = new ChannelSetHelper();
        for (File imageFile : imageFiles) {
            String[] tokens;
            String baseName;
            if (operationLog.isDebugEnabled()) {
                operationLog.debug(String.format("Processing image file '%s'", imageFile));
            }
            if (!(baseName = FilenameUtils.getBaseName((String)imageFile.getPath())).startsWith(FILE_PREFIX) || (tokens = StringUtils.split((String)baseName, (char)'_')).length != 5) continue;
            Location plateLocation = HCSImageFileExtractor.tryGetPlateLocation(tokens[1]);
            Location wellLocation = this.tryGetWellLocation(tokens[2]);
            int wavelength = this.getWavelength(tokens[3]);
            if (wellLocation != null && plateLocation != null && wavelength > 0) {
                helper.addWavelength(wavelength);
                accepter.accept(wavelength, plateLocation, wellLocation, imageFile);
                if (!operationLog.isDebugEnabled()) continue;
                operationLog.debug(String.format(IMAGE_FILE_ACCEPTED, imageFile, wavelength, plateLocation, wellLocation));
                continue;
            }
            if (operationLog.isDebugEnabled()) {
                operationLog.debug(String.format(IMAGE_FILE_NOT_STANDARDIZABLE, imageFile, tokens[0], tokens[1], tokens[2]));
            }
            invalidFiles.add(imageFile);
        }
        return new HCSImageFileExtractionResult(System.currentTimeMillis() - start, imageFiles.size(), Collections.unmodifiableList(invalidFiles), helper.getChannelSet());
    }

    private void checkIncomingDirectory(File incomingDataSetDirectory) {
        if (!incomingDataSetDirectory.isDirectory()) {
            throw UserFailureException.fromTemplate("Given incoming data set '%s' must be a directory.", incomingDataSetDirectory.getPath());
        }
    }
}

