/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSet {
    private final Map<String, List<String>> map = new HashMap<String, List<String>>();
    private final Set<String> namesOfNonEmptyColumns = new LinkedHashSet<String>();

    private static final void checkListName(String listName) {
        assert (listName != null) : "List name can not be null.";
    }

    protected final List<String> tryGetList(String listName) {
        ListSet.checkListName(listName);
        return this.map.get(listName);
    }

    public final void addToList(String listName, String value) {
        List<String> list;
        ListSet.checkListName(listName);
        if (StringUtils.isNotEmpty((String)value)) {
            this.namesOfNonEmptyColumns.add(listName);
        }
        if ((list = this.map.get(listName)) == null) {
            list = new ArrayList<String>();
            this.map.put(listName, list);
        }
        list.add(value);
    }

    public final boolean containsList(String listName) {
        ListSet.checkListName(listName);
        return this.map.containsKey(listName);
    }

    public final String tryGetValueAt(String listName, int rowIndex) {
        List<String> list = this.tryGetList(listName);
        if (list == null) {
            return null;
        }
        return list.get(rowIndex);
    }

    public final Set<String> getNamesOfNonEmptyColumns() {
        return Collections.unmodifiableSet(this.namesOfNonEmptyColumns);
    }

    public final int getRowCount() {
        int rowCount = 0;
        for (List<String> list : this.map.values()) {
            int size = list.size();
            assert (rowCount == 0 || size == rowCount) : String.format("Lists do not have the same number of rows (%d != %d)", size, rowCount);
            rowCount = Math.max(rowCount, size);
        }
        return rowCount;
    }
}

