/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base.properties;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EntityDataType implements Serializable
{
    INT("INTEGER"),
    STRING("VARCHAR"),
    DOUBLE("REAL"),
    DATE("TIMESTAMP"),
    BOOLEAN("BOOLEAN"),
    VOCABULARY("CONTROLLEDVOCABULARY");

    private final String dataTypeCode;

    private EntityDataType(String dataTypeCode) {
        this.dataTypeCode = dataTypeCode;
    }

    public static final EntityDataType createFromSimple(String dataTypeCode) {
        EntityDataType[] entityDataTypeArray = EntityDataType.values();
        int n = entityDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityDataType type = entityDataTypeArray[n2];
            if (type.dataTypeCode.equals(dataTypeCode)) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException(String.format("No corresponding entity property type found for database type '%s'.", dataTypeCode));
    }

    public final String createSimple() {
        return this.dataTypeCode;
    }

    public final String toString() {
        return this.dataTypeCode;
    }
}

