/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.BooleanOptionHandler;

public class SampleMain {
    @Option(name="r", longName="--recursive", usage="recursively run something")
    private boolean recursive;
    @Option(name="o", usage="output to this file", metaVar="OUTPUT")
    private File out = new File(".");
    @Option(name="s", longName="str")
    private String str = "(default value)";
    @Option(name="n", longName="-number", required=true, usage="repeat <n> times\nusage can have new lines in it and also it can be verrrrrrrrrrrrrrrrrry long")
    private int num = -1;
    @Option(name="l", longName="--long-number", usage="repeat <n> times\nusage can have new lines in it and also it can be verrrrrrrrrrrrrrrrrry long")
    private long lnum = -1L;
    @Option(longName="custom", handler=BooleanOptionHandler.class, usage="boolean value for checking the custom handler")
    private boolean data;
    @Argument
    private List<String> arguments = new ArrayList<String>();
    private CmdLineParser parser = new CmdLineParser(this);

    public static void main(String[] args) throws IOException {
        new SampleMain().doMain(args);
    }

    @Option(longName="--help", usage="show this help")
    private void help(boolean exit) {
        this.parser.printHelp("java SampleMain", "[options...]", "arguments...", ExampleMode.ALL);
        if (exit) {
            System.exit(0);
        }
    }

    public void doMain(String[] args) throws IOException {
        this.parser.setUsageWidth(80);
        try {
            this.parser.parseArgument(args);
            if (this.arguments.isEmpty()) {
                throw new CmdLineException("No argument is given");
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            this.help(false);
            return;
        }
        if (this.recursive) {
            System.out.println("-r flag is set");
        }
        if (this.data) {
            System.out.println("-custom flag is set");
        }
        System.out.println("-str was " + this.str);
        if (this.num >= 0) {
            System.out.println("-n was " + this.num);
        }
        if (this.lnum >= 0L) {
            System.out.println("-l was " + this.lnum);
        }
        System.out.println("other arguments are:");
        for (String s : this.arguments) {
            System.out.println(s);
        }
        if (this.out != null) {
            System.out.close();
        }
    }
}

