/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumOptionHandler<T extends Enum<T>>
extends OptionHandler<T> {
    private final Class<T> enumType;

    public EnumOptionHandler(Option option, Setter<? super T> setter, Class<T> enumType) {
        super(option, setter);
        this.enumType = enumType;
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        this.set(params.getParameter(0));
        return 1;
    }

    @Override
    public void set(String value) throws CmdLineException {
        T enumValue = this.getEnumOption(value);
        if (enumValue == null) {
            throw new CmdLineException(Messages.ILLEGAL_OPERAND.format(this.getName(), value));
        }
        this.set(enumValue);
    }

    private T getEnumOption(String s) {
        Enum[] enumArray = (Enum[])this.enumType.getEnumConstants();
        int n = 0;
        int n2 = enumArray.length;
        while (n < n2) {
            Enum o = enumArray[n];
            if (o.name().equalsIgnoreCase(s)) {
                return (T)o;
            }
            ++n;
        }
        return null;
    }

    protected void set(T value) throws CmdLineException {
        this.setter.addValue(value);
    }

    @Override
    public String getDefaultMetaVariable() {
        String n = this.enumType.getName();
        int idx = n.lastIndexOf(46);
        if (idx >= 0) {
            n = n.substring(idx + 1);
        }
        return n.toUpperCase();
    }
}

