/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexOptionHandler
extends OptionHandler<Pattern> {
    public RegexOptionHandler(Option option, Setter<? super Pattern> setter) {
        super(option, setter);
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        this.set(params.getParameter(0));
        return 1;
    }

    @Override
    public void set(String value) throws CmdLineException {
        try {
            this.set(Pattern.compile(value));
        }
        catch (PatternSyntaxException ex) {
            throw new CmdLineException(String.valueOf(Messages.ILLEGAL_OPERAND.format(this.getName(), value)) + ": " + ex.getMessage());
        }
    }

    protected void set(Pattern value) throws CmdLineException {
        this.setter.addValue(value);
    }

    @Override
    public String getDefaultMetaVariable() {
        return "REGEX";
    }
}

