/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.parser.ParserException;

public final class IndexOutOfBoundsException
extends ParserException {
    static final String MESSAGE_FORMAT = "Not enough tokens are available (index: %d, available: %d)";
    private static final long serialVersionUID = 1L;
    private final int column;
    private final String[] lineTokens;

    public IndexOutOfBoundsException(int index, String[] lineTokens) {
        super(IndexOutOfBoundsException.createMessage(index, lineTokens));
        this.column = index;
        this.lineTokens = lineTokens;
    }

    private static final String createMessage(int index, String[] lineTokens) {
        assert (lineTokens != null) : "Line tokens can not be null.";
        assert (index >= lineTokens.length) : "Index must be out of range (otherwise no reason to call this exception).";
        return String.format(MESSAGE_FORMAT, index, lineTokens.length);
    }

    public final int getColumn() {
        return this.column;
    }

    public final String[] getLineTokens() {
        return this.lineTokens;
    }
}

