/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.collections.CollectionStyle;
import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.common.parser.ParserException;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MandatoryPropertyMissingException
extends ParserException {
    static final String MESSAGE_FORMAT = "Field/Property name(s) '%s' is(are) mandatory.";
    private static final long serialVersionUID = 1L;
    private final Set<String> missingMandatoryProperties;
    private final Set<String> mandatoryFields;

    public MandatoryPropertyMissingException(Set<String> mandatoryFields, Set<String> missingMandatoryProperties) {
        super(MandatoryPropertyMissingException.createMessage(missingMandatoryProperties));
        assert (mandatoryFields != null && mandatoryFields.size() > 0) : "Unspecified mandatory fields.";
        this.mandatoryFields = mandatoryFields;
        this.missingMandatoryProperties = missingMandatoryProperties;
    }

    private static final String createMessage(Set<String> missingMandatoryProperties) {
        assert (missingMandatoryProperties != null) : "Missing mandatory properties can not be null.";
        assert (missingMandatoryProperties.size() > 0) : "No reason to throw this exception.";
        return String.format(MESSAGE_FORMAT, MandatoryPropertyMissingException.toString(missingMandatoryProperties));
    }

    static final String toString(Set<String> set) {
        return CollectionUtils.abbreviate(set, -1, CollectionStyle.NO_BOUNDARY);
    }

    public final Set<String> getMissingMandatoryProperties() {
        return Collections.unmodifiableSet(this.missingMandatoryProperties);
    }

    public final Set<String> getMandatoryFields() {
        return Collections.unmodifiableSet(this.mandatoryFields);
    }
}

