/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.parser.DefaultParser;
import ch.systemsx.cisd.common.parser.DefaultPropertyMapper;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.Line;
import ch.systemsx.cisd.common.parser.ParsingException;
import ch.systemsx.cisd.common.parser.filter.AlwaysAcceptLineFilter;
import ch.systemsx.cisd.common.parser.filter.ILineFilter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabFileLoader<T> {
    private static final String PREFIX = "#";
    private final IParserObjectFactoryFactory<T> factory;

    public TabFileLoader(IParserObjectFactoryFactory<T> factory) {
        assert (factory != null) : "Undefined factory";
        this.factory = factory;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<T> load(File file) {
        List<T> list;
        assert (file != null) : "Given file must not be null";
        assert (file.isFile()) : "Given file '" + file.getAbsolutePath() + "' is not a file.";
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            list = this.load(reader);
        }
        catch (IOException ex) {
            try {
                throw new EnvironmentFailureException(ex.getMessage());
                catch (ParsingException ex2) {
                    this.throwParsingException(ex2, file);
                    throw new AssertionError((Object)"We should never reach this point.");
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return list;
    }

    public final List<T> load(Reader reader) {
        ArrayList result = new ArrayList();
        Iterator<Line> lineIterator = this.createLineIterator(reader);
        if (!lineIterator.hasNext()) {
            return result;
        }
        Line previousLine = null;
        Line line = null;
        boolean previousLineHasColumnHeaders = false;
        while (lineIterator.hasNext()) {
            previousLineHasColumnHeaders = previousLine != null && PREFIX.equals(previousLine.getText());
            previousLine = line;
            line = lineIterator.next();
            if (!line.getText().startsWith(PREFIX)) break;
        }
        String headerLine = previousLineHasColumnHeaders ? previousLine.getText().substring(1) : line.getText();
        DefaultParser<T> parser = new DefaultParser<T>();
        String[] tokens = StringUtils.split(headerLine, "\t");
        int headerLength = tokens.length;
        TabFileLoader.notUnique(tokens);
        DefaultPropertyMapper propertyMapper = new DefaultPropertyMapper(tokens);
        parser.setObjectFactory(this.factory.createFactory(propertyMapper));
        ILineFilter filter = AlwaysAcceptLineFilter.INSTANCE;
        if (previousLineHasColumnHeaders) {
            result.addAll(parser.parse(Arrays.asList(line).iterator(), filter, headerLength));
        }
        result.addAll(parser.parse(lineIterator, filter, headerLength));
        return result;
    }

    private Iterator<Line> createLineIterator(Reader reader) {
        final LineIterator lineIterator = IOUtils.lineIterator((Reader)reader);
        Iterator<Line> iterator = new Iterator<Line>(){
            private int lineNumber;

            @Override
            public void remove() {
                lineIterator.remove();
            }

            @Override
            public Line next() {
                return new Line(++this.lineNumber, lineIterator.nextLine());
            }

            @Override
            public boolean hasNext() {
                return lineIterator.hasNext();
            }
        };
        return iterator;
    }

    protected void throwParsingException(ParsingException parsingException, File file) {
        throw parsingException;
    }

    private static final void notUnique(String[] tokens) {
        assert (tokens != null) : "Given tokens can not be null.";
        HashSet<String> unique = new HashSet<String>();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!unique.add(token.toLowerCase())) {
                throw new IllegalArgumentException(String.format("Duplicated column name '%s'.", token));
            }
            ++n2;
        }
    }
}

