/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.parser.MandatoryPropertyMissingException;
import ch.systemsx.cisd.common.parser.ParserException;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmatchedPropertiesException
extends ParserException {
    static final String MESSAGE_FORMAT = "Following header columns are not part of '%s': %s";
    private static final long serialVersionUID = 1L;
    private final Class<?> beanClass;
    private final Set<String> allPropertyNames;
    private final Set<String> mandatoryNames;
    private final Set<String> optionalNames;
    private final Set<String> propertyNames;

    public UnmatchedPropertiesException(Class<?> beanClass, Set<String> allPropertyNames, Set<String> mandatoryNames, Set<String> optionalNames, Set<String> propertyNames) {
        super(UnmatchedPropertiesException.createMessage(beanClass, propertyNames));
        assert (allPropertyNames != null) : "All property names can not be null.";
        assert (mandatoryNames != null) : "Mandatory names can not be null.";
        assert (optionalNames != null) : "Optional names can not be null.";
        this.beanClass = beanClass;
        this.allPropertyNames = allPropertyNames;
        this.mandatoryNames = mandatoryNames;
        this.optionalNames = optionalNames;
        this.propertyNames = propertyNames;
    }

    private static final String createMessage(Class<?> beanClass, Set<String> propertyNames) {
        assert (beanClass != null) : "Bean class can not be null.";
        assert (propertyNames != null) : "Property names can not be null.";
        assert (propertyNames.size() > 0) : "There is no reason to throw this exception.";
        return String.format(MESSAGE_FORMAT, beanClass.getSimpleName(), MandatoryPropertyMissingException.toString(propertyNames));
    }

    public final Class<?> getBeanClass() {
        return this.beanClass;
    }

    public final Set<String> getAllPropertyNames() {
        return Collections.unmodifiableSet(this.allPropertyNames);
    }

    public final Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.propertyNames);
    }

    public final Set<String> getMandatoryNames() {
        return Collections.unmodifiableSet(this.mandatoryNames);
    }

    public final Set<String> getOptionalNames() {
        return Collections.unmodifiableSet(this.optionalNames);
    }
}

