/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.process;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.IProcess;
import java.io.File;
import org.apache.log4j.Logger;

public final class FileRenamingProcess
implements IProcess {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FileRenamingProcess.class);
    public static final long DEFAULT_MILLIS_TO_SLEEP = 5000L;
    public static final int DEFAULT_MAX_RETRIES = 12;
    private final File sourceFile;
    private final File destinationFile;
    private final int maxRetries;
    private final long millisToSleep;
    private int failures;
    private boolean renamed;

    public FileRenamingProcess(File sourceFile, File destinationFile) {
        this(12, 5000L, sourceFile, destinationFile);
    }

    public FileRenamingProcess(int maxRetries, long millisToSleep, File sourceFile, File destinationFile) {
        this.sourceFile = sourceFile;
        this.maxRetries = maxRetries;
        this.millisToSleep = millisToSleep;
        this.destinationFile = destinationFile;
    }

    public final boolean isRenamed() {
        return this.renamed;
    }

    public final int getMaxRetryOnFailure() {
        return this.maxRetries;
    }

    public final long getMillisToSleepOnFailure() {
        return this.millisToSleep;
    }

    public final void run() {
        this.renamed = this.sourceFile.renameTo(this.destinationFile);
    }

    public final boolean succeeded() {
        if (!this.renamed) {
            if (!this.sourceFile.exists()) {
                operationLog.error(String.format("Path '%s' doesn't exist, so it can't be moved to '%s'.", this.sourceFile, this.destinationFile));
                return true;
            }
            operationLog.warn(String.format("Moving path '%s' to directory '%s' failed (attempt %d).", this.sourceFile, this.destinationFile, ++this.failures));
        }
        return true;
    }
}

