/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.process;

import ch.systemsx.cisd.common.process.ProcessResult;
import ch.systemsx.cisd.common.utilities.OSUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessExecutionHelper {
    public static final int NO_EXIT_VALUE = -1;
    public static final int EXIT_VALUE_OK = 0;
    private static final int EXIT_VALUE_FOR_TERMINATION_UNIX = 143;
    private static final int EXIT_VALUE_FOR_TERMINATION_WINDOWS = 1;
    private final Logger operationLog;
    private final Logger machineLog;

    public static boolean runAndLog(List<String> commandLine, Logger operationLog, Logger machineLog) {
        return new ProcessExecutionHelper(operationLog, machineLog).runAndLog(commandLine, 0L);
    }

    public static ProcessResult run(List<String> commandLine, Logger operationLog, Logger machineLog) {
        return new ProcessExecutionHelper(operationLog, machineLog).run(commandLine, 0L);
    }

    public static boolean runAndLog(List<String> cmd, long millisToWaitForCompletion, Logger operationLog, Logger machineLog) {
        return new ProcessExecutionHelper(operationLog, machineLog).runAndLog(cmd, millisToWaitForCompletion);
    }

    public static ProcessResult run(List<String> cmd, long millisToWaitForCompletion, Logger operationLog, Logger machineLog) {
        return new ProcessExecutionHelper(operationLog, machineLog).run(cmd, millisToWaitForCompletion);
    }

    public static boolean isProcessTerminated(int exitValue) {
        if (OSUtilities.isWindows()) {
            return exitValue == 1;
        }
        return exitValue == 143;
    }

    public static List<String> readProcessOutputLines(Process processOrNull, Logger machineLog) {
        ArrayList<String> processOutput = new ArrayList<String>();
        if (processOrNull == null) {
            return processOutput;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(processOrNull.getInputStream()));
        try {
            try {
                String ln;
                while ((ln = reader.readLine()) != null) {
                    processOutput.add(ln);
                }
            }
            catch (IOException e) {
                machineLog.warn(String.format("IOException when reading stdout, msg='%s'.", e.getMessage()));
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return processOutput;
    }

    private ProcessExecutionHelper(Logger operationLog, Logger machineLog) {
        this.operationLog = operationLog;
        this.machineLog = machineLog;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ProcessResult run(List<String> commandLine, long millisoWaitForCompletion) {
        Process process;
        ProcessStatus processStatus = new ProcessStatus(true);
        Timer watchDogOrNull = null;
        boolean isInterrupted = false;
        watchDogOrNull = this.tryCreateWatchDog(processStatus, millisoWaitForCompletion, commandLine.get(0));
        try {
            process = this.launchProcess(commandLine);
            processStatus.setProcess(process);
        }
        catch (IOException ex) {
            processStatus.interruptionUnnecesary();
            ProcessResult processResult = this.createNotStartedResult(commandLine, ex);
            if (watchDogOrNull == null) return processResult;
            watchDogOrNull.cancel();
            return processResult;
        }
        try {
            try {
                process.waitFor();
                processStatus.interruptionUnnecesary();
            }
            catch (InterruptedException ex) {
                processStatus.interruptionUnnecesary();
                this.logInterruption(commandLine.get(0), processStatus, ex);
                isInterrupted = true;
                if (watchDogOrNull == null) return this.createResult(commandLine, processStatus.tryGetProcess(), isInterrupted);
                watchDogOrNull.cancel();
                return this.createResult(commandLine, processStatus.tryGetProcess(), isInterrupted);
            }
        }
        catch (Throwable throwable) {
            if (watchDogOrNull == null) throw throwable;
            watchDogOrNull.cancel();
            throw throwable;
        }
        if (watchDogOrNull == null) return this.createResult(commandLine, processStatus.tryGetProcess(), isInterrupted);
        watchDogOrNull.cancel();
        return this.createResult(commandLine, processStatus.tryGetProcess(), isInterrupted);
    }

    private Process launchProcess(List<String> commandLine) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        processBuilder.redirectErrorStream(true);
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug("Executing command: " + commandLine);
        }
        Process process = processBuilder.start();
        return process;
    }

    private ProcessResult createNotStartedResult(List<String> commandLine, IOException ex) {
        this.machineLog.error(String.format("Cannot execute executable %s", commandLine), ex);
        return ProcessResult.createNotStarted(commandLine, this.operationLog, this.machineLog);
    }

    private ProcessResult createResult(List<String> commandLine, Process processOrNull, boolean isInterrupted) {
        if (processOrNull == null) {
            return ProcessResult.createNotStarted(commandLine, this.operationLog, this.machineLog);
        }
        if (isInterrupted) {
            return ProcessResult.createWaitingInterrupted(processOrNull, commandLine, this.operationLog, this.machineLog);
        }
        return ProcessResult.create(processOrNull, commandLine, this.operationLog, this.machineLog);
    }

    private void logInterruption(String commandLine, ProcessStatus terminationStatus, InterruptedException ex) {
        if (!terminationStatus.isInterruptedAfterTimeout()) {
            this.machineLog.error(String.format("Execution of %s interrupted", commandLine), ex);
        } else {
            this.operationLog.warn(String.format("Execution of %s interrupted after timeout", commandLine));
        }
    }

    private Timer tryCreateWatchDog(final ProcessStatus processStatus, final long millisToWaitForCompletion, final String commandForLog) {
        Timer watchDogOrNull;
        if (millisToWaitForCompletion > 0L) {
            final Thread processThread = Thread.currentThread();
            watchDogOrNull = new Timer(String.format("Watch Dog [%s]", commandForLog));
            watchDogOrNull.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ProcessExecutionHelper.this.operationLog.warn(String.format("Destroy process since it didn't finish in %d milli seconds", millisToWaitForCompletion));
                    Process process = processStatus.tryGetProcess();
                    if (process != null) {
                        process.destroy();
                        this.sleep(millisToWaitForCompletion / 2L);
                    }
                    ProcessStatus processStatus2 = processStatus;
                    synchronized (processStatus2) {
                        if (processStatus.canInterrupt()) {
                            processStatus.setInterruptedAfterTimeout();
                            ProcessExecutionHelper.this.operationLog.info(String.format("Interrupting waiting for the process %s by the watchDog", commandForLog));
                            processThread.interrupt();
                        }
                    }
                }

                private void sleep(long millisToWait) {
                    try {
                        Thread.sleep(millisToWait);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }, millisToWaitForCompletion);
        } else {
            watchDogOrNull = null;
        }
        return watchDogOrNull;
    }

    private boolean runAndLog(List<String> cmd, long millisToWaitForCompletion) {
        ProcessResult result = this.run(cmd, millisToWaitForCompletion);
        result.log();
        result.destroyProcess();
        return result.isOK();
    }

    public static void logProcessExecution(String commandName, int exitValue, List<String> processOutput, Logger operationLog, Logger machineLog) {
        if (exitValue != 0) {
            ProcessExecutionHelper.logProcessExitValue(Level.WARN, operationLog, commandName, exitValue);
            ProcessExecutionHelper.logProcessOutput(Level.WARN, machineLog, commandName, processOutput);
        } else if (operationLog.isDebugEnabled()) {
            ProcessExecutionHelper.logProcessExitValue(Level.DEBUG, operationLog, commandName, exitValue);
            ProcessExecutionHelper.logProcessOutput(Level.DEBUG, machineLog, commandName, processOutput);
        }
    }

    private static void logProcessExitValue(Level logLevel, Logger operationLog, String commandName, int exitValue) {
        assert (logLevel != null);
        assert (operationLog != null);
        assert (commandName != null);
        if (ProcessExecutionHelper.isProcessTerminated(exitValue)) {
            operationLog.log(logLevel, String.format("[%s] process was destroyed.", commandName));
        } else {
            operationLog.log(logLevel, String.format("[%s] process returned with exit value %d.", commandName, exitValue));
        }
    }

    private static void logProcessOutput(Level logLevel, Logger machineLog, String commandName, List<String> processOutputLines) {
        assert (logLevel != null);
        assert (machineLog != null);
        assert (commandName != null);
        assert (processOutputLines != null);
        if (processOutputLines.size() == 0) {
            return;
        }
        machineLog.log(logLevel, String.format("[%s] output:", commandName));
        for (String ln : processOutputLines) {
            if (ln.trim().length() <= 0) continue;
            machineLog.log(logLevel, String.format("\"%s\"", ln));
        }
    }

    private static class ProcessStatus {
        private boolean canInterrupt;
        private boolean isInterruptedAfterTimeout;
        private Process processOrNull;

        public ProcessStatus(boolean canInterrupt) {
            this.canInterrupt = canInterrupt;
            this.isInterruptedAfterTimeout = false;
        }

        public synchronized void interruptionUnnecesary() {
            this.canInterrupt = false;
        }

        public synchronized boolean canInterrupt() {
            return this.canInterrupt;
        }

        public synchronized void setInterruptedAfterTimeout() {
            this.interruptionUnnecesary();
            this.isInterruptedAfterTimeout = true;
        }

        public synchronized boolean isInterruptedAfterTimeout() {
            return this.isInterruptedAfterTimeout;
        }

        public synchronized Process tryGetProcess() {
            return this.processOrNull;
        }

        public synchronized void setProcess(Process process) {
            this.processOrNull = process;
        }
    }
}

