/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.process;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.process.IProcess;

public final class ProcessRunner {
    public ProcessRunner(IProcess process) {
        ProcessRunner.runProcess(process);
    }

    static final void runProcess(IProcess process) {
        int maxRetryOnFailure = process.getMaxRetryOnFailure();
        long millisToSleepOnFailure = process.getMillisToSleepOnFailure();
        assert (millisToSleepOnFailure > -1L);
        int counter = 0;
        do {
            process.run();
            if (counter <= 0 || millisToSleepOnFailure <= 0L) continue;
            try {
                Thread.sleep(millisToSleepOnFailure);
            }
            catch (InterruptedException ex) {
                throw new CheckedExceptionTunnel(ex);
            }
        } while (++counter < maxRetryOnFailure && !process.succeeded());
    }
}

