/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.collections.CollectionIO;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.common.utilities.IPathHandler;
import ch.systemsx.cisd.common.utilities.IStoreHandler;
import ch.systemsx.cisd.common.utilities.StoreItem;
import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public final class DirectoryScanningTimerTask
extends TimerTask {
    static final String FAULTY_PATH_FILENAME = ".faulty_paths";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DirectoryScanningTimerTask.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DirectoryScanningTimerTask.class);
    private final IStoreHandler handler;
    private final IScannedStore sourceDirectory;
    private final int ignoredErrorCount;
    private int errorCountReadingDirectory;
    private final Set<String> faultyPaths;
    private final File faultyPathsFile;
    private long faultyPathsLastChanged;

    public DirectoryScanningTimerTask(File sourceDirectory, FileFilter filter, IPathHandler handler) {
        this(sourceDirectory, filter, handler, 0);
    }

    public DirectoryScanningTimerTask(File sourceDirectory, FileFilter filter, IPathHandler handler, int ignoredErrorCount) {
        this(DirectoryScanningTimerTask.asScannedStore(sourceDirectory, filter), sourceDirectory, DirectoryScanningTimerTask.asScanningHandler(sourceDirectory, handler), ignoredErrorCount);
    }

    public DirectoryScanningTimerTask(IScannedStore scannedStore, File faultyPathDirectory, IStoreHandler handler, int ignoredErrorCount) {
        assert (scannedStore != null);
        assert (handler != null);
        assert (ignoredErrorCount >= 0);
        this.ignoredErrorCount = ignoredErrorCount;
        this.sourceDirectory = scannedStore;
        this.handler = handler;
        this.faultyPaths = new HashSet<String>();
        this.faultyPathsFile = new File(faultyPathDirectory, FAULTY_PATH_FILENAME);
        this.faultyPathsFile.delete();
    }

    private static IStoreHandler asScanningHandler(final File directory, final IPathHandler handler) {
        return new IStoreHandler(){

            public void handle(StoreItem item) {
                File path = DirectoryScanningTimerTask.asFile(directory, item);
                handler.handle(path);
            }
        };
    }

    private static IScannedStore asScannedStore(final File directory, final FileFilter filter) {
        return new IScannedStore(){

            public String getLocationDescription(StoreItem item) {
                return DirectoryScanningTimerTask.getLocationDescription(this.asFile(item));
            }

            public boolean exists(StoreItem item) {
                return this.asFile(item).exists();
            }

            public StoreItem[] tryListSortedReadyToProcess(ISimpleLogger loggerOrNull) {
                File[] files = FileUtilities.tryListFiles(directory, filter, loggerOrNull);
                if (files != null) {
                    FileUtilities.sortByLastModified(files);
                    return this.asItems(files);
                }
                return null;
            }

            private StoreItem[] asItems(File[] files) {
                StoreItem[] items = new StoreItem[files.length];
                int i = 0;
                while (i < items.length) {
                    items[i] = new StoreItem(files[i].getName());
                    ++i;
                }
                return items;
            }

            private File asFile(StoreItem item) {
                return DirectoryScanningTimerTask.asFile(directory, item);
            }
        };
    }

    private static String getLocationDescription(File file) {
        return file.getPath();
    }

    private static File asFile(File parentDirectory, StoreItem item) {
        return new File(parentDirectory, item.getName());
    }

    public void run() {
        try {
            StoreItem[] paths;
            if (operationLog.isTraceEnabled()) {
                operationLog.trace("Start scanning directory " + this.sourceDirectory + ".");
            }
            this.checkForFaultyPathsFileChanged();
            StoreItem[] storeItemArray = paths = this.listFiles();
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                StoreItem path = storeItemArray[n2];
                if (!this.isFaultyPathsFile(path)) {
                    try {
                        this.handle(path);
                    }
                    catch (Exception ex) {
                        this.printNotification(ex);
                    }
                }
                ++n2;
            }
            if (operationLog.isTraceEnabled()) {
                operationLog.trace("Finished scanning directory " + this.sourceDirectory + ".");
            }
        }
        catch (Exception ex) {
            this.printNotification(ex);
        }
    }

    private void printNotification(Exception ex) {
        notificationLog.error("An exception has occurred. (thread still running)", ex);
    }

    private boolean isFaultyPathsFile(StoreItem item) {
        String itemLocation = this.sourceDirectory.getLocationDescription(item);
        String faultyPathsLocation = DirectoryScanningTimerTask.getLocationDescription(this.faultyPathsFile);
        return itemLocation.equals(faultyPathsLocation);
    }

    private void checkForFaultyPathsFileChanged() {
        if (this.faultyPathsFile.exists()) {
            if (this.faultyPathsFile.lastModified() > this.faultyPathsLastChanged) {
                this.faultyPaths.clear();
                CollectionIO.readCollection(this.faultyPathsFile, this.faultyPaths);
                this.faultyPathsLastChanged = this.faultyPathsFile.lastModified();
                if (operationLog.isInfoEnabled()) {
                    operationLog.info(String.format("Reread faulty paths file (%s), new set contains %d entries", DirectoryScanningTimerTask.getLocationDescription(this.faultyPathsFile), this.faultyPaths.size()));
                }
            }
        } else {
            this.faultyPaths.clear();
        }
    }

    private StoreItem[] listFiles() {
        boolean logOperationError;
        boolean logNotifyError = this.errorCountReadingDirectory == this.ignoredErrorCount;
        boolean bl = logOperationError = this.errorCountReadingDirectory < this.ignoredErrorCount;
        ISimpleLogger errorLogger = logNotifyError ? this.createSimpleErrorLogger(LogCategory.NOTIFY) : (logOperationError ? this.createSimpleErrorLogger(LogCategory.OPERATION) : null);
        StoreItem[] paths = this.sourceDirectory.tryListSortedReadyToProcess(errorLogger);
        if (this.errorCountReadingDirectory > this.ignoredErrorCount && paths != null && notificationLog.isInfoEnabled()) {
            notificationLog.info(String.format("Directory '%s' is available again.", this.sourceDirectory));
        }
        this.errorCountReadingDirectory = paths == null ? ++this.errorCountReadingDirectory : 0;
        return paths == null ? new StoreItem[]{} : paths;
    }

    private ISimpleLogger createSimpleErrorLogger(final LogCategory category) {
        return new ISimpleLogger(){

            public void log(LogLevel dummyLevel, String message) {
                if (category == LogCategory.NOTIFY) {
                    notificationLog.log(Level.ERROR, message);
                } else {
                    operationLog.log(Level.WARN, message);
                }
            }
        };
    }

    private void handle(StoreItem item) {
        if (this.isFaultyPath(item)) {
            return;
        }
        try {
            this.handler.handle(item);
        }
        finally {
            if (this.sourceDirectory.exists(item)) {
                this.addToFaultyPaths(item);
            }
        }
    }

    private boolean isFaultyPath(StoreItem item) {
        String path = this.sourceDirectory.getLocationDescription(item);
        return this.faultyPaths.contains(path);
    }

    private void addToFaultyPaths(StoreItem item) {
        String path = this.sourceDirectory.getLocationDescription(item);
        this.faultyPaths.add(path);
        CollectionIO.writeIterable(this.faultyPathsFile, this.faultyPaths);
        this.faultyPathsLastChanged = this.faultyPathsFile.lastModified();
    }

    public static interface IScannedStore {
        public StoreItem[] tryListSortedReadyToProcess(ISimpleLogger var1);

        public boolean exists(StoreItem var1);

        public String getLocationDescription(StoreItem var1);
    }
}

