/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.parser.filter.AlwaysAcceptLineFilter;
import ch.systemsx.cisd.common.parser.filter.ILineFilter;
import ch.systemsx.cisd.common.utilities.FileComparator;
import ch.systemsx.cisd.common.utilities.StringUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtilities {
    public static final FileFilter ACCEPT_ALL_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return true;
        }
    };
    private static final Pattern ONE_OR_MORE_DIGITS = Pattern.compile(".*(\\d+)$");

    private FileUtilities() {
    }

    public static void copyFileTo(File sourceFile, File destinationFile, boolean preservesLastModifiedDate) throws CheckedExceptionTunnel {
        boolean successful;
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            try {
                inputStream = new FileInputStream(sourceFile);
                outputStream = new FileOutputStream(destinationFile);
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (IOException ex) {
                throw new EnvironmentFailureException("Couldn't copy file '" + sourceFile + "' to '" + destinationFile + "'.", ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        if (preservesLastModifiedDate && !(successful = destinationFile.setLastModified(sourceFile.lastModified()))) {
            throw new EnvironmentFailureException("Couldn't copy last modified date of file '" + sourceFile + "' to '" + destinationFile + "' for some unknown reason.");
        }
    }

    public static String loadToString(File file) throws CheckedExceptionTunnel {
        String string;
        assert (file != null);
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            string = FileUtilities.readString(new BufferedReader(fileReader));
        }
        catch (IOException ex) {
            try {
                throw new CheckedExceptionTunnel(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)fileReader);
        return string;
    }

    public static void writeToFile(File file, String str) throws CheckedExceptionTunnel {
        assert (file != null) : "Unspecified file.";
        assert (str != null) : "Unspecified string.";
        FileWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(file);
                fileWriter.write(str);
            }
            catch (IOException ex) {
                throw new CheckedExceptionTunnel(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    public static final List<String> loadToStringList(File file) throws CheckedExceptionTunnel {
        return FileUtilities.loadToStringList(file, null);
    }

    public static final List<String> loadToStringList(File file, ILineFilter lineFilterOrNull) throws CheckedExceptionTunnel {
        List<String> list;
        assert (file != null) : "Unspecified file.";
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            list = FileUtilities.readStringList(new BufferedReader(fileReader), lineFilterOrNull);
        }
        catch (IOException ex) {
            try {
                throw new CheckedExceptionTunnel(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)fileReader);
        return list;
    }

    public static String loadToString(Class<?> clazz, String resource) throws CheckedExceptionTunnel {
        assert (clazz != null) : "Given class can not be null.";
        assert (resource != null && resource.length() > 0) : "Given resource can not be null.";
        BufferedReader reader = null;
        try {
            reader = FileUtilities.tryGetBufferedReader(clazz, resource);
            String string = reader == null ? null : FileUtilities.readString(reader);
            return string;
        }
        catch (IOException ex) {
            throw new CheckedExceptionTunnel(ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static final List<String> loadToStringList(Class<?> clazz, String resource) throws CheckedExceptionTunnel {
        return FileUtilities.loadToStringList(clazz, resource, null);
    }

    public static final List<String> loadToStringList(Class<?> clazz, String resource, ILineFilter lineFilterOrNull) throws CheckedExceptionTunnel {
        assert (clazz != null) : "Given class can not be null.";
        assert (StringUtils.isNotEmpty(resource)) : "Given resource can not be empty.";
        BufferedReader reader = null;
        try {
            reader = FileUtilities.tryGetBufferedReader(clazz, resource);
            List<String> list = reader == null ? null : FileUtilities.readStringList(reader, lineFilterOrNull);
            return list;
        }
        catch (IOException ex) {
            throw new CheckedExceptionTunnel(ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    private static final BufferedReader tryGetBufferedReader(Class<?> clazz, String resource) throws FileNotFoundException {
        URL url = clazz.getResource(resource);
        if (url == null) {
            return null;
        }
        try {
            return new BufferedReader(new FileReader(new File(url.toURI())));
        }
        catch (URISyntaxException ex) {
            throw new CheckedExceptionTunnel(ex);
        }
    }

    private static String readString(BufferedReader reader) throws IOException {
        String line;
        assert (reader != null) : "Unspecified BufferedReader.";
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line).append('\n');
        }
        return builder.toString();
    }

    private static final List<String> readStringList(BufferedReader reader, ILineFilter lineFilterOrNull) throws IOException {
        assert (reader != null) : "Unspecified BufferedReader.";
        ILineFilter lineFilter = lineFilterOrNull == null ? AlwaysAcceptLineFilter.INSTANCE : lineFilterOrNull;
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        int lineNumber = 0;
        while (line != null) {
            if (lineFilter.acceptLine(line, lineNumber)) {
                list.add(line);
            }
            ++lineNumber;
            line = reader.readLine();
        }
        return list;
    }

    public static String checkPathFullyAccessible(File path, String kindOfPath) {
        assert (path != null);
        assert (kindOfPath != null);
        return FileUtilities.checkPathFullyAccessible(path, kindOfPath, "path");
    }

    public static String checkDirectoryFullyAccessible(File directory, String kindOfDirectory) {
        assert (directory != null);
        assert (kindOfDirectory != null);
        String msg = FileUtilities.checkPathFullyAccessible(directory, kindOfDirectory, "directory");
        if (msg == null && !directory.isDirectory()) {
            return String.format("Path '%s' is supposed to be a %s directory, but is a file.", directory.getPath(), kindOfDirectory);
        }
        return msg;
    }

    private static String checkPathFullyAccessible(File path, String kindOfPath, String directoryOrFile) {
        assert (path != null);
        assert (kindOfPath != null);
        assert (directoryOrFile != null);
        if (!path.canRead()) {
            if (!path.exists()) {
                return String.format("%s %s '%s' does not exist.", StringUtilities.capitalize(kindOfPath), directoryOrFile, path.getPath());
            }
            return String.format("%s %s '%s' is not readable.", StringUtilities.capitalize(kindOfPath), directoryOrFile, path.getPath());
        }
        if (!path.canWrite()) {
            return String.format("%s directory '%s' is not writable.", StringUtilities.capitalize(kindOfPath), path.getPath());
        }
        return null;
    }

    public static boolean deleteRecursively(File path) {
        assert (path != null);
        return FileUtilities.deleteRecursively(path, null);
    }

    public static boolean deleteRecursively(File path, ISimpleLogger loggerOrNull) {
        assert (path != null);
        if (path.isDirectory()) {
            File[] fileArray = path.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    FileUtilities.deleteRecursively(file, loggerOrNull);
                } else {
                    if (loggerOrNull != null) {
                        loggerOrNull.log(LogLevel.INFO, String.format("Deleting file '%s'", file.getPath()));
                    }
                    file.delete();
                }
                ++n2;
            }
        }
        if (loggerOrNull != null) {
            loggerOrNull.log(LogLevel.INFO, String.format("Deleting directory '%s'", path.getPath()));
        }
        return path.delete();
    }

    public static boolean deleteRecursively(File path, FileFilter filter, ISimpleLogger logger) {
        assert (path != null);
        assert (filter != null);
        if (filter.accept(path)) {
            return FileUtilities.deleteRecursively(path, logger);
        }
        if (path.isDirectory()) {
            File[] fileArray = path.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileUtilities.deleteRecursively(file, filter, logger);
                ++n2;
            }
        }
        return false;
    }

    public static long lastChanged(File path, boolean subDirectoriesOnly, long stopWhenFindYounger) {
        return new LastChangedWorker(path, subDirectoriesOnly, stopWhenFindYounger, false).getLastChanged();
    }

    public static long lastChangedRelative(File path, boolean subDirectoriesOnly, long stopWhenFindYoungerRelative) {
        return new LastChangedWorker(path, subDirectoriesOnly, stopWhenFindYoungerRelative, true).getLastChanged();
    }

    public static long lastChanged(File path) {
        return FileUtilities.lastChanged(path, false, 0L);
    }

    public static final File removePrefixFromFileName(File file, String prefix) {
        assert (file != null);
        String name = file.getName();
        if (StringUtils.isEmpty(prefix)) {
            return file;
        }
        if (name.indexOf(prefix) < 0) {
            return file;
        }
        return new File(file.getParent(), name.substring(prefix.length()));
    }

    public static final File createNextNumberedFile(File path, Pattern regex) {
        return FileUtilities.createNextNumberedFile(path, regex, null);
    }

    public static final File createNextNumberedFile(File path, Pattern regexOrNull, String defaultFileNameOrNull) {
        Pattern pattern;
        assert (path != null);
        if (!path.exists()) {
            return path;
        }
        if (regexOrNull == null) {
            pattern = ONE_OR_MORE_DIGITS;
        } else {
            assert (regexOrNull.pattern().indexOf("(\\d+)") > -1 || regexOrNull.pattern().indexOf("([0-9]+)") > -1);
            pattern = regexOrNull;
        }
        String pathName = path.getName();
        Matcher matcher = pattern.matcher(pathName);
        boolean found = matcher.find();
        if (!found) {
            String fileName = !StringUtils.isEmpty(defaultFileNameOrNull) ? defaultFileNameOrNull : String.valueOf(pathName) + "1";
            return FileUtilities.createNextNumberedFile(new File(path.getParent(), fileName), pattern, defaultFileNameOrNull);
        }
        StringBuilder builder = new StringBuilder();
        int nextStart = 0;
        while (found) {
            String group = matcher.group(1);
            int newNumber = Integer.parseInt(group) + 1;
            builder.append(pathName.substring(nextStart, matcher.start(1))).append(newNumber);
            nextStart = matcher.end(1);
            found = matcher.find();
        }
        builder.append(pathName.substring(nextStart));
        File newFile = new File(path.getParent(), builder.toString());
        if (newFile.exists()) {
            return FileUtilities.createNextNumberedFile(newFile, pattern, defaultFileNameOrNull);
        }
        return newFile;
    }

    public static final String getRelativeFile(File root, File file) {
        assert (root != null) : "Given root can not be null.";
        assert (file != null) : "Given file can not be null.";
        String rootPath = String.valueOf(root.getAbsolutePath()) + File.separator;
        String filePath = file.getAbsolutePath();
        if (filePath.startsWith(rootPath)) {
            return filePath.substring(rootPath.length());
        }
        return null;
    }

    public static File[] tryListFiles(File directory, ISimpleLogger loggerOrNull) {
        return FileUtilities.tryListFiles(directory, ACCEPT_ALL_FILTER, loggerOrNull);
    }

    public static File[] tryListFiles(File directory, FileFilter filter, ISimpleLogger loggerOrNull) {
        File[] paths = null;
        RuntimeException ex = null;
        try {
            paths = directory.listFiles(filter);
        }
        catch (RuntimeException e) {
            ex = e;
        }
        if (paths == null && loggerOrNull != null) {
            FileUtilities.logFailureInDirectoryListing(ex, directory, loggerOrNull);
        }
        return paths;
    }

    public static void sortByLastModified(File[] files) {
        Arrays.sort(files, FileComparator.BY_LAST_MODIFIED);
    }

    private static void logFailureInDirectoryListing(RuntimeException exOrNull, File directory, ISimpleLogger logger) {
        if (exOrNull == null) {
            if (directory.isFile()) {
                logger.log(LogLevel.ERROR, String.format("Failed to get listing of directory '%s' (path is file instead of directory).", directory));
            } else {
                logger.log(LogLevel.ERROR, String.format("Failed to get listing of directory '%s' (path not found).", directory));
            }
        } else {
            StringWriter exStackWriter = new StringWriter();
            exOrNull.printStackTrace(new PrintWriter(exStackWriter));
            logger.log(LogLevel.ERROR, String.format("Failed to get listing of directory '%s'. Exception: %s", directory, exStackWriter.toString()));
        }
    }

    public static final String copyResourceToTempFile(String resource, String prefix, String postfix) {
        InputStream resourceStream = FileUtilities.class.getResourceAsStream(resource);
        if (resourceStream == null) {
            throw new IllegalArgumentException("Resource '" + resource + "' not found.");
        }
        try {
            File tempFile = File.createTempFile(prefix, postfix);
            tempFile.deleteOnExit();
            FileOutputStream fileStream = new FileOutputStream(tempFile);
            try {
                IOUtils.copy((InputStream)resourceStream, (OutputStream)fileStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)fileStream);
            }
            String string = tempFile.getAbsolutePath();
            return string;
        }
        catch (IOException ex) {
            throw new CheckedExceptionTunnel(ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)resourceStream);
        }
    }

    public static final String tryCopyResourceToTempFile(String resource, String prefix, String postfix) {
        try {
            return FileUtilities.copyResourceToTempFile(resource, prefix, postfix);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final File[] listFiles(File directory) throws EnvironmentFailureException {
        File[] fileList = directory.listFiles();
        if (fileList == null) {
            throw EnvironmentFailureException.fromTemplate("Failed to get listing of directory '%s'", directory.getAbsolutePath());
        }
        return fileList;
    }

    public static final File normalizeFile(File file) {
        assert (file != null) : "Given file can not be null.";
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return new File(FilenameUtils.normalize((String)file.getAbsolutePath()));
        }
    }

    public static final String getCanonicalPath(File file) {
        assert (file != null) : "Given file can not be null.";
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static final boolean isAvailable(final File path, final long timeOutMillis) {
        final Semaphore sem = new Semaphore(1);
        sem.acquireUninterruptibly();
        Thread t = new Thread(new Runnable(){

            public void run() {
                boolean pathExists = false;
                while (true) {
                    if (pathExists = path.exists()) {
                        sem.release();
                        return;
                    }
                    try {
                        Thread.sleep(timeOutMillis / 10L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        }, "Path Availability Checker: " + path.getPath());
        t.start();
        try {
            boolean exists = sem.tryAcquire(timeOutMillis, TimeUnit.MILLISECONDS);
            if (!exists) {
                t.interrupt();
            }
            return exists;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private static final class LastChangedWorker {
        private boolean subDirectoriesOnly;
        private final long reference;
        private final boolean referenceIsRelative;
        private long lastChanged;
        private boolean terminated;

        LastChangedWorker(File root, boolean subDirectoriesOnly, long reference, boolean referenceIsRelative) {
            assert (root != null);
            this.subDirectoriesOnly = subDirectoriesOnly;
            this.reference = reference;
            this.referenceIsRelative = referenceIsRelative;
            this.terminated = false;
            this.lastChanged = 0L;
            this.updateLastChanged(root);
            if (!this.terminated) {
                this.traverse(root);
            }
        }

        private void updateLastChanged(File path) {
            assert (path != null);
            if (!path.canRead()) {
                throw new CheckedExceptionTunnel(new IOException(String.format("Path '%s' cannot be read.", path.getPath())));
            }
            long lastModified = path.lastModified();
            this.lastChanged = Math.max(lastModified, this.lastChanged);
            if (this.isYoungEnough(this.lastChanged)) {
                this.terminated = true;
            }
        }

        private boolean isYoungEnough(long currentLastChanged) {
            if (this.referenceIsRelative) {
                return this.reference > 0L && currentLastChanged > System.currentTimeMillis() - this.reference;
            }
            return this.reference > 0L && currentLastChanged > this.reference;
        }

        private void traverse(File path) {
            assert (path != null);
            if (!path.isDirectory()) {
                return;
            }
            File[] fileArray = this.getEntries(path);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File entry = fileArray[n2];
                this.updateLastChanged(entry);
                if (this.terminated) {
                    return;
                }
                if (Thread.interrupted()) {
                    throw new CheckedExceptionTunnel(new InterruptedException("lastChanged() interrupted"));
                }
                this.traverse(entry);
                ++n2;
            }
        }

        private File[] getEntries(File directory) {
            assert (directory != null);
            if (this.subDirectoriesOnly) {
                return directory.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                });
            }
            return directory.listFiles();
        }

        long getLastChanged() {
            return this.lastChanged;
        }
    }
}

