/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template {
    private static final char PLACEHOLDER_ESCAPE_CHARACTER = '$';
    private static final char PLACEHOLDER_START_CHARACTER = '{';
    private static final char PLACEHOLDER_END_CHARACTER = '}';
    private final Map<String, VariableToken> variableTokens;
    private final List<IToken> tokens;

    private static final String createPlaceholder(String variableName) {
        return String.valueOf('$') + '{' + variableName + '}';
    }

    public Template(String template) {
        this(new LinkedHashMap<String, VariableToken>(), new ArrayList<IToken>());
        assert (template != null) : "Unspecified template.";
        TokenBuilder tokenBuilder = new TokenBuilder(this.variableTokens, this.tokens);
        State state = State.PLAIN;
        int n = template.length();
        int i = 0;
        while (i < n) {
            state = state.next(template.charAt(i), tokenBuilder);
            ++i;
        }
        if (state != State.PLAIN) {
            throw new IllegalArgumentException("Incomplete placeholder detected at the end.");
        }
        tokenBuilder.finishPlainToken();
    }

    private Template(Map<String, VariableToken> variableTokens, List<IToken> tokens) {
        this.variableTokens = variableTokens;
        this.tokens = tokens;
    }

    public Template createFreshCopy() {
        LinkedHashMap<String, VariableToken> map = new LinkedHashMap<String, VariableToken>();
        for (VariableToken variableToken : this.variableTokens.values()) {
            String variableName = variableToken.getVariableName();
            map.put(variableName, new VariableToken(variableName));
        }
        ArrayList<IToken> list = new ArrayList<IToken>();
        for (IToken token : this.tokens) {
            if (token instanceof VariableToken) {
                list.add(map.get(((VariableToken)token).getVariableName()));
                continue;
            }
            list.add(token);
        }
        return new Template(map, list);
    }

    public void bind(String placeholderName, String value) {
        boolean successful = this.attemptToBind(placeholderName, value);
        if (!successful) {
            throw new IllegalArgumentException("Unknown variable '" + placeholderName + "'.");
        }
    }

    public boolean attemptToBind(String placeholderName, String value) {
        assert (placeholderName != null) : "Unspecified placeholder name.";
        assert (value != null) : "Unspecified value for '" + placeholderName + "'";
        VariableToken variableToken = this.variableTokens.get(placeholderName);
        if (variableToken == null) {
            return false;
        }
        variableToken.bind(value);
        return true;
    }

    public String createText() {
        return this.createText(true);
    }

    public String createText(boolean complete) {
        if (complete) {
            this.assertAllVariablesAreBound();
        }
        StringBuilder builder = new StringBuilder();
        for (IToken token : this.tokens) {
            token.appendTo(builder);
        }
        return builder.toString();
    }

    private void assertAllVariablesAreBound() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, VariableToken> entry : this.variableTokens.entrySet()) {
            if (entry.getValue().isBound()) continue;
            builder.append(entry.getKey()).append(' ');
        }
        if (builder.length() > 0) {
            throw new IllegalStateException("The following variables are not bound: " + builder);
        }
    }

    private static interface IToken {
        public void appendTo(StringBuilder var1);
    }

    private static final class PlainToken
    implements IToken {
        private final String plainText;

        PlainToken(String plainText) {
            assert (plainText != null) : "Unspecified plain text.";
            this.plainText = plainText;
        }

        public void appendTo(StringBuilder builder) {
            builder.append(this.plainText);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        PLAIN{

            State next(char character, TokenBuilder tokenBuilder) {
                if (character == '$') {
                    return STARTING_PLACEHOLDER;
                }
                tokenBuilder.addCharacter(character);
                return PLAIN;
            }
        }
        ,
        STARTING_PLACEHOLDER{

            State next(char character, TokenBuilder tokenBuilder) {
                switch (character) {
                    case '$': {
                        tokenBuilder.addCharacter('$');
                        return PLAIN;
                    }
                    case '{': {
                        tokenBuilder.finishPlainToken();
                        return PLACEHOLDER;
                    }
                }
                tokenBuilder.addCharacter('$');
                tokenBuilder.addCharacter(character);
                return PLAIN;
            }
        }
        ,
        PLACEHOLDER{

            State next(char character, TokenBuilder tokenBuilder) {
                if (character == '}') {
                    tokenBuilder.finishPlaceholder();
                    return PLAIN;
                }
                tokenBuilder.addCharacter(character);
                return PLACEHOLDER;
            }
        };


        abstract State next(char var1, TokenBuilder var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TokenBuilder {
        private final Map<String, VariableToken> variableTokens;
        private final List<IToken> tokens;
        private final StringBuilder builder;

        TokenBuilder(Map<String, VariableToken> variableTokens, List<IToken> tokens) {
            this.variableTokens = variableTokens;
            this.tokens = tokens;
            this.builder = new StringBuilder();
        }

        public void addCharacter(char character) {
            this.builder.append(character);
        }

        public void finishPlainToken() {
            if (this.builder.length() > 0) {
                this.tokens.add(new PlainToken(this.builder.toString()));
                this.builder.setLength(0);
            }
        }

        public void finishPlaceholder() {
            String variableName = this.builder.toString();
            if (variableName.length() == 0) {
                throw new IllegalArgumentException("Nameless placeholder " + Template.createPlaceholder("") + " found.");
            }
            VariableToken token = this.variableTokens.get(variableName);
            if (token == null) {
                token = new VariableToken(variableName);
                this.variableTokens.put(variableName, token);
            }
            this.tokens.add(token);
            this.builder.setLength(0);
        }
    }

    private static final class VariableToken
    implements IToken {
        private final String variableName;
        private String value;

        VariableToken(String variablePlaceHolder) {
            assert (variablePlaceHolder != null) : "Unspecified variable place holder.";
            this.variableName = variablePlaceHolder;
        }

        public void appendTo(StringBuilder builder) {
            builder.append(this.isBound() ? this.value : Template.createPlaceholder(this.variableName));
        }

        String getVariableName() {
            return this.variableName;
        }

        boolean isBound() {
            return this.value != null;
        }

        void bind(String v) {
            this.value = v;
        }
    }
}

