/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration.h2;

import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.dbmigration.IMassUploader;
import ch.systemsx.cisd.dbmigration.MassUploadFileType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2MassUploader
extends SimpleJdbcDaoSupport
implements IMassUploader {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, H2MassUploader.class);
    private final ISequenceNameMapper sequenceNameMapper;

    public H2MassUploader(DataSource dataSource, ISequenceNameMapper sequenceNameMapper) throws SQLException {
        this.sequenceNameMapper = sequenceNameMapper;
        this.setDataSource(dataSource);
    }

    @Override
    public final void performMassUpload(File[] massUploadFiles) {
        String task = "Get database metadata";
        try {
            ArrayList<MassUploadRecord> massUploadRecords = new ArrayList<MassUploadRecord>(massUploadFiles.length);
            DatabaseMetaData dbMetaData = this.getConnection().getMetaData();
            try {
                File[] fileArray = massUploadFiles;
                int n = massUploadFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File massUploadFile = fileArray[n2];
                    String[] splitName = StringUtils.split(massUploadFile.getName(), "=");
                    assert (splitName.length == 2) : "Missing '=' in name of file '" + massUploadFile.getName() + "'.";
                    String tableNameWithExtension = splitName[1];
                    boolean tsvFileType = MassUploadFileType.TSV.isOfType(tableNameWithExtension);
                    assert (tsvFileType) : "Not a " + MassUploadFileType.TSV.getFileType() + " file: " + massUploadFile.getName();
                    String tableName = tableNameWithExtension.substring(0, tableNameWithExtension.lastIndexOf(46));
                    BitSet isBinaryColumn = this.findBinaryColumns(dbMetaData, tableName);
                    massUploadRecords.add(new MassUploadRecord(massUploadFile, tableName, isBinaryColumn));
                    ++n2;
                }
            }
            finally {
                task = "Close connection";
                dbMetaData.getConnection().close();
            }
            for (MassUploadRecord record : massUploadRecords) {
                this.performMassUpload(record);
            }
            for (MassUploadRecord record : massUploadRecords) {
                this.fixSequence(record.tableName);
            }
        }
        catch (SQLException ex) {
            throw new UncategorizedSQLException(task, "UNKNOWN", ex);
        }
    }

    private final void performMassUpload(final MassUploadRecord record) {
        try {
            List<String[]> rows;
            int numberOfRows;
            if (operationLog.isInfoEnabled()) {
                operationLog.info("Perform mass upload of file '" + record.massUploadFile + "' to table '" + record.tableName + "'.");
            }
            final int numberOfColumns = (numberOfRows = (rows = this.readTSVFile(record.massUploadFile)).size()) > 0 ? rows.get(0).length : 0;
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("insert into ");
            insertSql.append(record.tableName);
            insertSql.append(" values (");
            int i = 0;
            while (i < numberOfColumns) {
                insertSql.append("?,");
                ++i;
            }
            insertSql.setLength(insertSql.length() - 1);
            insertSql.append(')');
            this.getJdbcTemplate().batchUpdate(insertSql.toString(), new BatchPreparedStatementSetter(){

                public int getBatchSize() {
                    return numberOfRows;
                }

                public void setValues(PreparedStatement ps, int rowNo) throws SQLException {
                    int colNo = 0;
                    while (colNo < numberOfColumns) {
                        ps.setObject(colNo + 1, this.tryGetValue(rowNo, colNo));
                        ++colNo;
                    }
                }

                private Object tryGetValue(int rowNo, int colNo) {
                    String stringValueOrNull = ((String[])rows.get(rowNo))[colNo];
                    if (stringValueOrNull == null) {
                        return null;
                    }
                    if (record.isBinaryColumn.get(colNo)) {
                        return stringValueOrNull.getBytes();
                    }
                    return stringValueOrNull;
                }
            });
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private final BitSet findBinaryColumns(DatabaseMetaData dbMetaData, String tableName) throws SQLException {
        BitSet binary = new BitSet();
        ResultSet rs = dbMetaData.getColumns(null, null, tableName.toUpperCase(), "%");
        int columnNo = 0;
        while (rs.next()) {
            int typeCode = rs.getInt(5);
            binary.set(columnNo, typeCode == -2 || typeCode == -3);
            ++columnNo;
        }
        rs.close();
        return binary;
    }

    private final List<String[]> readTSVFile(File tsvFile) throws IOException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(FileUtils.openInputStream((File)tsvFile)));
        try {
            String line = reader.readLine();
            int numberOfColumns = -1;
            while (line != null) {
                if (line.trim().length() > 0) {
                    String[] cols = StringUtils.splitPreserveAllTokens(line, '\t');
                    if (numberOfColumns < 0) {
                        numberOfColumns = cols.length;
                    }
                    if (numberOfColumns != cols.length) {
                        throw new IllegalArgumentException("line '" + line + "', cols found: " + cols.length + ", cols expected: " + numberOfColumns);
                    }
                    int i = 0;
                    while (i < cols.length) {
                        cols[i] = StringUtils.replace(cols[i], "\\\\011", "\t");
                        cols[i] = StringUtils.replace(cols[i], "\\\\012", "\n");
                        if ("\\N".equals(cols[i])) {
                            cols[i] = null;
                        }
                        ++i;
                    }
                    result.add(cols);
                }
                line = reader.readLine();
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return result;
    }

    private final void fixSequence(String tableName) {
        String sequenceName = this.sequenceNameMapper.getSequencerForTable(tableName);
        if (sequenceName == null) {
            return;
        }
        try {
            long maxId = this.getSimpleJdbcTemplate().queryForLong(String.format("select max(id) from %s", tableName), new Object[0]);
            long newSequenceValue = maxId + 1L;
            if (operationLog.isInfoEnabled()) {
                operationLog.info("Updating sequence " + sequenceName + " for table " + tableName + " to value " + newSequenceValue);
            }
            this.getJdbcTemplate().execute(String.format("alter sequence %s restart with %d", sequenceName, newSequenceValue));
        }
        catch (DataAccessException ex) {
            operationLog.error("Failed to set new value for sequence '" + sequenceName + "' of table '" + tableName + "'.", ex);
        }
    }

    private static final class MassUploadRecord {
        final File massUploadFile;
        final String tableName;
        final BitSet isBinaryColumn;

        MassUploadRecord(File massUploadFile, String tableName, BitSet isBinaryColumn) {
            this.massUploadFile = massUploadFile;
            this.tableName = tableName;
            this.isBinaryColumn = isBinaryColumn;
        }
    }
}

