/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration.postgresql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import org.apache.commons.io.IOUtils;

public class DumpPreparator {
    private static final Set<String> FILTERED_SCHEMA_LINES = new LinkedHashSet<String>((Collection)Arrays.asList("SET client_encoding = 'UTF8';", "COMMENT ON SCHEMA public IS 'Standard public schema';", "CREATE PROCEDURAL LANGUAGE plpgsql;"));

    public static void main(String[] args) throws IOException {
        File dumpFile;
        if (args.length < 1) {
            System.out.println("Usage: java ch.systemsx.cisd.dbmigration.postgresql.DumpPreparator <main folder> [<dump file>]");
            System.exit(1);
        }
        File destination = new File(args[0]);
        if (args.length == 1) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setSelectedFile(new File(System.getProperty("user.dir")));
            int response = fileChooser.showOpenDialog(null);
            if (response != 0) {
                System.exit(0);
            }
            dumpFile = fileChooser.getSelectedFile();
        } else {
            dumpFile = new File(args[1]);
        }
        System.out.println("Parsing PostgreSQL dump file " + dumpFile.getAbsolutePath());
        DumpPreparator.createUploadFiles(dumpFile, destination);
        System.out.println("Dump preparation successfully finished.");
    }

    public static void createUploadFiles(File dumpFile, File destination) throws IOException {
        FileReader reader = new FileReader(dumpFile);
        try {
            DumpPreparator.createUploadFiles(reader, destination);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    static void createUploadFiles(Reader dumpReader, File destinationFolder) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(dumpReader);
        State state = State.SCHEMA;
        UploadFileManager uploadFileManager = new UploadFileManager(destinationFolder, FILTERED_SCHEMA_LINES);
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0 || line.startsWith("--")) continue;
            state = state.processLine(line, uploadFileManager);
        }
        uploadFileManager.save();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        SCHEMA{

            State processLine(String line, UploadFileManager manager) {
                if (COPY_PATTERN.matcher(line).matches()) {
                    return COPY_LINE.processLine(line, manager);
                }
                manager.addSchemaLine(line);
                return this;
            }
        }
        ,
        COPY_LINE{

            State processLine(String line, UploadFileManager manager) {
                Matcher matcher = COPY_PATTERN.matcher(line);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Couldn't extract table name from the following line: " + line);
                }
                manager.createUploadFile(matcher.group(1));
                return IN_COPY;
            }
        }
        ,
        IN_COPY{

            State processLine(String line, UploadFileManager manager) {
                return manager.addTableLine(line) ? COPY : this;
            }
        }
        ,
        COPY{

            State processLine(String line, UploadFileManager manager) {
                if (COPY_PATTERN.matcher(line).matches()) {
                    return COPY_LINE.processLine(line, manager);
                }
                return FIX.processLine(line, manager);
            }
        }
        ,
        FIX{

            State processLine(String line, UploadFileManager manager) {
                manager.addFinishLine(line);
                return this;
            }
        };

        private static final Pattern COPY_PATTERN;

        static {
            COPY_PATTERN = Pattern.compile("COPY (\\w*).*");
        }

        State processLine(String line, UploadFileManager manager) {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Table {
        private static int counter;
        private final String uploadFileName;
        private final List<String> rows = new ArrayList<String>();

        Table(String tableName) {
            this.uploadFileName = String.format("%03d=%s.tsv", ++counter, tableName);
        }

        void addRow(String line) {
            this.rows.add(line);
        }

        public final String getUploadFileName() {
            return this.uploadFileName;
        }

        public final List<String> getRows() {
            return this.rows;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UploadFileManager {
        private static final String VERSION_LOGS_TABLE = "database_version_logs";
        private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d{3})\\t.*");
        private final File destinationFolder;
        private final Set<String> filteredSchemaLines;
        private final StringWriter schemaScript = new StringWriter();
        private final PrintWriter schemaPrinter = new PrintWriter((Writer)this.schemaScript, true);
        private final StringWriter finishScript = new StringWriter();
        private final PrintWriter finishPrinter = new PrintWriter((Writer)this.finishScript, true);
        private final Map<String, Table> tables = new LinkedHashMap<String, Table>();
        private Table currentTable;

        UploadFileManager(File destinationFolder, Set<String> filteredSchemaLines) {
            this.destinationFolder = destinationFolder;
            this.filteredSchemaLines = filteredSchemaLines;
        }

        void addSchemaLine(String line) {
            if (!this.filteredSchemaLines.contains(line)) {
                this.schemaPrinter.println(line);
            }
        }

        void addFinishLine(String line) {
            this.finishPrinter.println(line);
        }

        void createUploadFile(String tableName) {
            this.currentTable = new Table(tableName);
            this.tables.put(tableName, this.currentTable);
        }

        boolean addTableLine(String line) {
            if (this.currentTable == null) {
                throw new IllegalStateException("No table created to add the following line: " + line);
            }
            if (line.startsWith("\\.")) {
                return true;
            }
            this.currentTable.addRow(line);
            return false;
        }

        void save() throws IOException {
            String databaseVersion = this.getDatabaseVersion();
            File folder = this.createDestinationFolder();
            this.writeTo(folder, "schema-" + databaseVersion + ".sql", Arrays.asList(this.schemaScript.toString()));
            for (Table table : this.tables.values()) {
                List<String> rows = table.getRows();
                if (rows.size() <= 0) continue;
                this.writeTo(folder, table.getUploadFileName(), rows);
            }
            this.writeTo(folder, "finish-" + databaseVersion + ".sql", Arrays.asList(this.finishScript.toString()));
        }

        private void writeTo(File folder, String fileName, List<String> lines) throws IOException {
            PrintWriter writer = null;
            try {
                File file = new File(folder, fileName);
                System.out.println("   create " + file.getAbsolutePath());
                writer = new PrintWriter((Writer)new FileWriter(file), true);
                for (String line : lines) {
                    writer.println(line);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private File createDestinationFolder() {
            File folder = this.destinationFolder;
            if (folder.exists()) {
                File[] files;
                if (!folder.isDirectory()) throw new IllegalStateException("Is not a directory: " + folder.getAbsolutePath());
                File[] fileArray = files = folder.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        if (pathname.isDirectory()) {
                            return false;
                        }
                        String name = pathname.getName();
                        return name.endsWith(".tsv") || name.endsWith(".sql");
                    }
                });
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!file.delete()) {
                        throw new IllegalStateException("Couldn't delete file '" + file.getAbsolutePath() + "' for some unknown reasons.");
                    }
                    ++n2;
                }
                return folder;
            } else {
                if (folder.mkdirs()) return folder;
                throw new IllegalStateException("Couldn't create folder '" + folder.getAbsolutePath() + "' for some unknown reason.");
            }
        }

        private String getDatabaseVersion() {
            Table logTable = this.tables.get(VERSION_LOGS_TABLE);
            if (logTable == null) {
                throw new IllegalStateException("Table 'database_version_logs' missing.");
            }
            List<String> rows = logTable.getRows();
            String result = "000";
            for (String row : rows) {
                Matcher matcher = VERSION_PATTERN.matcher(row);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Row does not start with a version number: " + row);
                }
                String v = matcher.group(1);
                if (v.compareTo(result) <= 0) continue;
                result = v;
            }
            return result;
        }
    }
}

