/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration.postgresql;

import ch.systemsx.cisd.common.Script;
import ch.systemsx.cisd.common.db.ISqlScriptExecutor;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.dbmigration.DBUtilities;
import ch.systemsx.cisd.dbmigration.IDatabaseAdminDAO;
import ch.systemsx.cisd.dbmigration.IMassUploader;
import ch.systemsx.cisd.dbmigration.MassUploadFileType;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;

public class PostgreSQLAdminDAO
extends SimpleJdbcDaoSupport
implements IDatabaseAdminDAO {
    private static final String SQL_FILE_TYPE = ".sql";
    private static final String CREATE_DATABASE_SQL_TEMPLATE = "create database %1$s with owner = %2$s encoding = 'utf8' tablespace = pg_default; alter database %1$s set default_with_oids = off;";
    private static final String CREATE_TABLE_DATABASE_VERSION_LOGS_SQL = "create table database_version_logs (db_version varchar(4) not null, module_name varchar(250), run_status varchar(10), run_status_timestamp timestamp, module_code bytea, run_exception bytea);";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PostgreSQLAdminDAO.class);
    private final ISqlScriptExecutor scriptExecutor;
    private final IMassUploader massUploader;
    private final String owner;
    private final String databaseName;
    private final String databaseURL;

    public PostgreSQLAdminDAO(DataSource dataSource, ISqlScriptExecutor scriptExecutor, IMassUploader massUploader, String owner, String databaseName, String databaseURL) {
        this.scriptExecutor = scriptExecutor;
        this.massUploader = massUploader;
        this.owner = owner;
        this.databaseName = databaseName;
        this.databaseURL = databaseURL;
        this.setDataSource(dataSource);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public void createOwner() {
        try {
            this.getJdbcTemplate().execute("create user " + this.owner);
            if (operationLog.isInfoEnabled()) {
                operationLog.info("Created role '" + this.owner + "'.");
            }
        }
        catch (DataAccessException ex) {
            if (DBUtilities.isDuplicateObjectException(ex)) {
                if (operationLog.isInfoEnabled()) {
                    operationLog.info("Role '" + this.owner + "' already exists.");
                }
            }
            operationLog.error("Database role '" + this.owner + "' couldn't be created:", ex);
            throw ex;
        }
    }

    public void createDatabase() {
        this.createEmptyDatabase();
        this.createDatabaseVersionLogsTable();
    }

    private void createDatabaseVersionLogsTable() {
        try {
            this.scriptExecutor.execute(new Script("create database_version_logs table", CREATE_TABLE_DATABASE_VERSION_LOGS_SQL), true, null);
        }
        catch (RuntimeException ex) {
            operationLog.error("Failed to create database_version_logs table.", ex);
            throw ex;
        }
    }

    private void createEmptyDatabase() {
        operationLog.info("Try to create empty database '" + this.databaseName + "' with owner '" + this.owner + "'.");
        try {
            this.getJdbcTemplate().execute(String.format(CREATE_DATABASE_SQL_TEMPLATE, this.databaseName, this.owner));
        }
        catch (RuntimeException ex) {
            if (ex instanceof DataAccessException && DBUtilities.isDuplicateDatabaseException((DataAccessException)((Object)ex))) {
                operationLog.warn("Cannot create database '" + this.databaseName + "' since it already exists.");
            }
            operationLog.error("Failed to create database '" + this.databaseName + "'.", ex);
            throw ex;
        }
    }

    public void dropDatabase() {
        block2: {
            try {
                this.getJdbcTemplate().execute("drop database " + this.databaseName);
            }
            catch (DataAccessException ex) {
                if (DBUtilities.isDBNotExistException(ex)) break block2;
                throw ex;
            }
        }
    }

    public void restoreDatabaseFromDump(File dumpFolder, String version) {
        this.createEmptyDatabase();
        Script schemaScript = this.tryLoadScript(dumpFolder, "schema", version);
        this.scriptExecutor.execute(schemaScript, false, null);
        File[] massUploadFiles = this.getMassUploadFiles(dumpFolder);
        this.massUploader.performMassUpload(massUploadFiles);
        Script finishScript = this.tryLoadScript(dumpFolder, "finish", version);
        this.scriptExecutor.execute(finishScript, false, null);
    }

    private Script tryLoadScript(File dumpFolder, String prefix, String version) throws ConfigurationFailureException {
        File scriptFile = new File(dumpFolder, String.valueOf(prefix) + "-" + version + SQL_FILE_TYPE);
        if (!scriptFile.canRead()) {
            String message = "No " + prefix + " script found for version " + version;
            operationLog.error(message);
            throw new ConfigurationFailureException(message);
        }
        Script script = new Script(scriptFile.getPath(), FileUtilities.loadToString(scriptFile), version);
        return script;
    }

    private File[] getMassUploadFiles(File dumpFolder) {
        Object[] csvFiles;
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("Searching for mass upload files in directory '" + dumpFolder.getAbsolutePath() + "'.");
        }
        if ((csvFiles = dumpFolder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return MassUploadFileType.CSV.isOfType(name) || MassUploadFileType.TSV.isOfType(name);
            }
        })) == null) {
            operationLog.warn("Path '" + dumpFolder.getAbsolutePath() + "' is not a directory.");
            return new File[0];
        }
        Arrays.sort(csvFiles);
        if (operationLog.isInfoEnabled()) {
            operationLog.info("Found " + csvFiles.length + " files for mass uploading.");
        }
        File[] csvPaths = new File[csvFiles.length];
        int i = 0;
        while (i < csvFiles.length) {
            csvPaths[i] = new File(dumpFolder, (String)csvFiles[i]);
            ++i;
        }
        return csvPaths;
    }
}

