/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base;

import ch.systemsx.cisd.common.utilities.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.lims.base.EntityType;
import ch.systemsx.cisd.lims.base.IEntityPropertiesHolder;
import ch.systemsx.cisd.lims.base.SampleCriteria;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class NewSample
implements Serializable,
IEntityPropertiesHolder {
    private static final long serialVersionUID = 17L;
    private final SampleCriteria sampleCriteria = new SampleCriteria();
    private String generatedFrom;
    private String controlLayoutCode;
    private SimpleEntityProperty[] properties;

    public NewSample() {
    }

    public NewSample(SampleCriteria sampleCriteria, String controlLayoutCodeOrNull) {
        this.setCode(sampleCriteria.getSampleCode());
        this.setSampleTypeCode(sampleCriteria.getSampleTypeCode());
        this.setControlLayoutCode(controlLayoutCodeOrNull);
    }

    public EntityType getEntityType() {
        String sampleTypeCode = this.getSampleTypeCode();
        return new EntityType(sampleTypeCode, "Sample of type " + sampleTypeCode);
    }

    public SimpleEntityProperty[] getProperties() {
        return this.properties;
    }

    public void setProperties(SimpleEntityProperty[] properties) {
        this.properties = properties;
    }

    public final String getSampleCriteria() {
        return this.sampleCriteria.getSampleCode();
    }

    public final void setCode(String code) {
        this.sampleCriteria.setSampleCode(code);
    }

    public final String getGeneratedFrom() {
        return this.generatedFrom;
    }

    public final void setGeneratedFrom(String generatedFrom) {
        this.generatedFrom = generatedFrom;
    }

    public final String getSampleTypeCode() {
        return this.sampleCriteria.getSampleTypeCode();
    }

    public final void setSampleTypeCode(String sampleTypeCode) {
        this.sampleCriteria.setSampleTypeCode(sampleTypeCode);
    }

    public final String getControlLayoutCode() {
        return StringUtils.isEmpty(this.controlLayoutCode) ? null : this.controlLayoutCode;
    }

    public final void setControlLayoutCode(String controlLayoutCode) {
        this.controlLayoutCode = controlLayoutCode;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NewSample)) {
            return false;
        }
        NewSample that = (NewSample)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(that.getSampleCriteria(), this.getSampleCriteria());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.getSampleCriteria());
        return builder.toHashCode();
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString(this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
    }
}

