/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base.masterplate;

import ch.systemsx.cisd.common.exceptions.InternalErr;
import ch.systemsx.cisd.common.utilities.MatrixComparator;
import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.ListSet;
import ch.systemsx.cisd.lims.base.Material;
import ch.systemsx.cisd.lims.base.MaterialBatch;
import ch.systemsx.cisd.lims.base.SampleComponent;
import ch.systemsx.cisd.lims.base.SampleCriteria;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.base.masterplate.IMasterPlateDataProvider;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.EntityProperties;
import ch.systemsx.cisd.lims.base.properties.EntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.EntityPropertySchema;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityPropertySchema;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class MasterPlateLoader {
    public static final String GENE_SYMBOL_PROPERTY_CODE = "USER.GENE_SYMBOL";
    static final SampleComponentComparator SAMPLE_COMPONENT_COMPARATOR = new SampleComponentComparator();
    private final IMasterPlateDataProvider dataProvider;
    private final boolean markControlWells;

    public static ListSet createTable(final ILIMSService limsService, final String sessionToken, SampleComponent[] sampleComponents, boolean markControlWells, boolean prettyMode) {
        IMasterPlateDataProvider dataProvider = new IMasterPlateDataProvider(){

            public final SimpleEntityPropertySchema[] listPropertyTypes(String materialTypeCode) {
                return limsService.listEntityPropertyTypes(sessionToken, EntityKind.MATERIAL, materialTypeCode);
            }
        };
        MasterPlateLoader masterPlateLoader = new MasterPlateLoader(dataProvider, markControlWells);
        ListSet listSet = new ListSet();
        masterPlateLoader.loadAndFill(listSet, sampleComponents, prettyMode);
        return listSet;
    }

    public MasterPlateLoader(IMasterPlateDataProvider dataProvider, boolean markControlWells) {
        assert (dataProvider != null) : "Unspecified data provider.";
        this.dataProvider = dataProvider;
        this.markControlWells = markControlWells;
    }

    public void loadAndFill(ListSet listSet, SampleComponent[] sampleComponents, boolean prettyMode) {
        Arrays.sort(sampleComponents, SAMPLE_COMPONENT_COMPARATOR);
        IEntityPropertiesSchema oligoSchema = this.loadSchema("OLIGO");
        String[] names = oligoSchema.getAllNames();
        IEntityPropertiesSchema geneSchema = this.loadSchema("GENE");
        EntityPropertySchema geneSymbolProperty = geneSchema.getPropertySchema(GENE_SYMBOL_PROPERTY_CODE);
        String geneSymbolLabel = prettyMode ? geneSymbolProperty.getUserLabel() : geneSymbolProperty.getCode();
        boolean overlappingChecked = false;
        SampleComponent[] sampleComponentArray = sampleComponents;
        int n = sampleComponents.length;
        int n2 = 0;
        while (n2 < n) {
            SampleComponent component = sampleComponentArray[n2];
            listSet.addToList(FieldName.WELL.getName(prettyMode), this.getCode(component));
            MaterialBatch mb = component.getMaterialBatch();
            listSet.addToList(FieldName.MATERIAL_BATCH.getName(prettyMode), mb.getCode());
            Material material = mb.getMaterial();
            listSet.addToList(FieldName.OLIGO.getName(prettyMode), material.getCode());
            Material inhibitorOf = material.getInhibitorOf();
            String geneCode = null;
            String geneSymbol = null;
            if (inhibitorOf != null) {
                geneCode = inhibitorOf.getCode();
                geneSymbol = this.getGeneSymbol(geneSchema, inhibitorOf);
            }
            listSet.addToList(FieldName.GENE_ID.getName(prettyMode), geneCode);
            listSet.addToList(geneSymbolLabel, geneSymbol);
            if (!overlappingChecked) {
                this.ensurePropertiesDoNotOverlap(listSet, names);
                overlappingChecked = true;
            }
            this.fillProperties(material, listSet, oligoSchema, names, prettyMode);
            ++n2;
        }
    }

    private void fillProperties(Material material, ListSet listSet, IEntityPropertiesSchema oligoSchema, String[] propertyNames, boolean prettyMode) {
        EntityProperties oligoProperties = null;
        if (this.isOligo(material)) {
            oligoProperties = this.transformProperties(material.getProperties(), oligoSchema);
        }
        String[] stringArray = propertyNames;
        int n = propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            EntityPropertySchema schema = oligoSchema.getPropertySchema(propertyName);
            String label = prettyMode ? schema.getUserLabel() : schema.getCode();
            String propertyValue = null;
            if (oligoProperties != null) {
                propertyValue = oligoProperties.getProperty(propertyName).tryGetUntypedValue();
            }
            listSet.addToList(label, propertyValue);
            ++n2;
        }
    }

    private boolean isOligo(Material material) {
        return material.getMaterialType().getCode().equals("OLIGO");
    }

    private String getGeneSymbol(IEntityPropertiesSchema geneSchema, Material gene) {
        EntityProperties geneProperties = this.transformProperties(gene.getProperties(), geneSchema);
        String geneSymbol = geneProperties.getProperty(GENE_SYMBOL_PROPERTY_CODE).tryAsString();
        return geneSymbol;
    }

    private void ensurePropertiesDoNotOverlap(ListSet listSet, String[] names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            if (listSet.containsList(propertyName)) {
                throw InternalErr.error();
            }
            ++n2;
        }
    }

    private EntityProperties transformProperties(SimpleEntityProperty[] properties, IEntityPropertiesSchema schema) {
        return EntityProperties.createFromSimple(properties, schema);
    }

    private IEntityPropertiesSchema loadSchema(String materialTypeCode) {
        SimpleEntityPropertySchema[] l = this.dataProvider.listPropertyTypes(materialTypeCode);
        return EntityPropertiesSchema.createFromSimple(l);
    }

    private String getCode(SampleComponent sampleComponent) {
        String code = sampleComponent.getCode();
        if (this.markControlWells && MasterPlateLoader.isControlWell(sampleComponent)) {
            code = "*" + code;
        }
        return code;
    }

    private static boolean isControlWell(SampleComponent sampleComponent) {
        SampleCriteria sampleCriteria = sampleComponent.getSampleCriteria();
        return sampleCriteria != null && sampleCriteria.getSampleTypeCode().equals(SampleTypeCode.CONTROL_LAYOUT.getCode());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SampleComponentComparator
    implements Comparator<SampleComponent>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final MatrixComparator MATRIX_COMPARATOR = new MatrixComparator();

        private SampleComponentComparator() {
        }

        @Override
        public final int compare(SampleComponent o1, SampleComponent o2) {
            return MATRIX_COMPARATOR.compare(o1.getCode(), o2.getCode());
        }
    }
}

