/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base.properties;

import ch.systemsx.cisd.common.exceptions.InternalErr;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.AbstractHashable;
import ch.systemsx.cisd.lims.base.properties.EntityDataType;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EntityPropertyValue
extends AbstractHashable {
    private static final String TRUE_VALUE = "true";
    private static final String FALSE_VALUE = "false";
    public static final SimpleDateFormat CANONICAL_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private final EntityDataType type;
    private final Object valueOrNull;

    private EntityPropertyValue(Object valueOrNull, EntityDataType type) {
        this.valueOrNull = valueOrNull;
        this.type = type;
    }

    public EntityDataType getType() {
        return this.type;
    }

    public boolean isNull() {
        return this.valueOrNull == null;
    }

    public static EntityPropertyValue createFromUntyped(String untypedValueOrNull, EntityDataType type) throws UserFailureException {
        if (untypedValueOrNull == null) {
            return new EntityPropertyValue(null, type);
        }
        try {
            return EntityPropertyValue.internalCreateFromUntyped(untypedValueOrNull, type);
        }
        catch (NumberFormatException numberFormatException) {
            throw UserFailureException.fromTemplate("Value '%s' has improper format. It should be of type '%s'", untypedValueOrNull, type);
        }
    }

    private static EntityPropertyValue internalCreateFromUntyped(String untypedValue, EntityDataType type) {
        if (type.equals(EntityDataType.INT)) {
            return EntityPropertyValue.createInteger(Integer.parseInt(untypedValue));
        }
        if (type.equals(EntityDataType.DOUBLE)) {
            return EntityPropertyValue.createDouble(Double.parseDouble(untypedValue));
        }
        if (type.equals(EntityDataType.STRING)) {
            return EntityPropertyValue.createString(untypedValue);
        }
        if (type.equals(EntityDataType.BOOLEAN)) {
            return EntityPropertyValue.createBoolean(EntityPropertyValue.parseBoolean(untypedValue));
        }
        if (type.equals(EntityDataType.DATE)) {
            return EntityPropertyValue.createDate(EntityPropertyValue.parseDate(untypedValue));
        }
        if (type.equals(EntityDataType.VOCABULARY)) {
            return EntityPropertyValue.createVocabularyTerm(untypedValue);
        }
        throw InternalErr.error();
    }

    private static Date parseDate(String untypedValue) {
        try {
            return CANONICAL_DATE_FORMAT.parse(untypedValue);
        }
        catch (ParseException parseException) {
            throw UserFailureException.fromTemplate("Date value '%s' has improper format. The proper format is '%s'.", untypedValue, CANONICAL_DATE_FORMAT.toPattern());
        }
    }

    private static Boolean parseBoolean(String untypedValue) {
        if (untypedValue.equalsIgnoreCase(TRUE_VALUE)) {
            return Boolean.TRUE;
        }
        if (untypedValue.equalsIgnoreCase(FALSE_VALUE)) {
            return Boolean.FALSE;
        }
        throw UserFailureException.fromTemplate("Boolean value '%s' has improper format. It should be either '%s' or '%s',", untypedValue, TRUE_VALUE, FALSE_VALUE);
    }

    public static EntityPropertyValue createInteger(Integer valOrNull) {
        return new EntityPropertyValue(valOrNull, EntityDataType.INT);
    }

    public static EntityPropertyValue createDouble(Double valOrNull) {
        return new EntityPropertyValue(valOrNull, EntityDataType.DOUBLE);
    }

    public static EntityPropertyValue createString(String valOrNull) {
        return new EntityPropertyValue(valOrNull, EntityDataType.STRING);
    }

    public static EntityPropertyValue createVocabularyTerm(String valOrNull) {
        return new EntityPropertyValue(valOrNull, EntityDataType.VOCABULARY);
    }

    public static EntityPropertyValue createBoolean(Boolean valOrNull) {
        return new EntityPropertyValue(valOrNull, EntityDataType.BOOLEAN);
    }

    public static EntityPropertyValue createDate(Date valOrNull) {
        return new EntityPropertyValue(valOrNull, EntityDataType.DATE);
    }

    public String tryAsString() {
        this.ensure(this.type.equals(EntityDataType.STRING));
        return (String)this.valueOrNull;
    }

    public String tryAsVocabularyTerm() {
        this.ensure(this.type.equals(EntityDataType.VOCABULARY));
        return (String)this.valueOrNull;
    }

    public Integer tryAsInteger() {
        this.ensure(this.type.equals(EntityDataType.INT));
        return (Integer)this.valueOrNull;
    }

    public Double tryAsDouble() {
        this.ensure(this.type.equals(EntityDataType.DOUBLE));
        return (Double)this.valueOrNull;
    }

    public Boolean tryAsBoolean() {
        this.ensure(this.type.equals(EntityDataType.BOOLEAN));
        return (Boolean)this.valueOrNull;
    }

    public Date tryAsDate() {
        this.ensure(this.type.equals(EntityDataType.DATE));
        return (Date)this.valueOrNull;
    }

    public String tryGetUntypedValue() {
        if (this.valueOrNull == null) {
            return null;
        }
        if (this.type.equals(EntityDataType.INT) || this.type.equals(EntityDataType.DOUBLE) || this.type.equals(EntityDataType.STRING) || this.type.equals(EntityDataType.VOCABULARY)) {
            return this.valueOrNull.toString();
        }
        if (this.type.equals(EntityDataType.BOOLEAN)) {
            return this.tryAsBoolean() != false ? TRUE_VALUE : FALSE_VALUE;
        }
        if (this.type.equals(EntityDataType.DATE)) {
            return CANONICAL_DATE_FORMAT.format(this.tryAsDate());
        }
        throw InternalErr.error();
    }

    private void ensure(boolean value) {
        assert (value) : "Type does not match";
    }

    public SimpleEntityProperty createSimple(String name, String userLabel) {
        return new SimpleEntityProperty(name, userLabel, this.type, (Serializable)this.valueOrNull);
    }

    public static EntityPropertyValue createFromSimple(SimpleEntityProperty property) {
        return new EntityPropertyValue(property.getValue(), property.getDataType());
    }
}

