/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.lims.base.EntityPropertyFiller;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.commands.BisTabFileLoader;
import ch.systemsx.cisd.lims.client.commands.IEntityTypeCodeProvider;
import ch.systemsx.cisd.lims.client.commands.factory.EntityPropertyFillerFactory;
import ch.systemsx.cisd.lims.client.parameters.AbstractParameters;
import ch.systemsx.cisd.lims.client.utilities.Utilities;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractAssignPropertyTypeCommand
extends AbstractCommandWithSessionToken {
    static final String VALUE_PARSER_PROPERTY = "value";
    static final String CODE_PARSER_PROPERTY = "code";
    private final EntityKind entityKind;

    AbstractAssignPropertyTypeCommand(String commandName, EntityKind entityKind) {
        super(commandName);
        this.entityKind = entityKind;
    }

    private final EntityPropertyFiller[] loadPropertyFillers(File file) {
        BisTabFileLoader<EntityPropertyFiller> tabFileLoader = new BisTabFileLoader<EntityPropertyFiller>(new IParserObjectFactoryFactory<EntityPropertyFiller>(){

            @Override
            public final IParserObjectFactory<EntityPropertyFiller> createFactory(IPropertyMapper propertyMapper) {
                return AbstractAssignPropertyTypeCommand.this.createParserObjectFactory(propertyMapper);
            }
        });
        return tabFileLoader.load(file).toArray(EntityPropertyFiller.EMPTY_ARRAY);
    }

    abstract AbstractAssignPropertyTypeParameters createParameters(String[] var1);

    abstract String getEntityTypeCode(IEntityTypeCodeProvider var1) throws UserFailureException;

    @Override
    protected final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        AbstractAssignPropertyTypeParameters parameters = this.createParameters(arguments);
        String propertyName = parameters.getPropertyName();
        ILIMSService limsService = this.getLIMSService(parameters);
        String entityTypeCode = this.getEntityTypeCode(parameters);
        EntityPropertyFiller[] propertyFillers = EntityPropertyFiller.EMPTY_ARRAY;
        File propertyFillersFile = parameters.tryGetFile();
        if (propertyFillersFile != null) {
            propertyFillers = this.loadPropertyFillers(propertyFillersFile);
        }
        boolean mandatory = parameters.isMandatory();
        String successMsg = limsService.assignEntityPropertyType(sessionToken, this.entityKind, entityTypeCode, propertyName, mandatory, propertyFillers, parameters.getGlobalValue());
        System.out.println(successMsg);
        return 0;
    }

    IParserObjectFactory<EntityPropertyFiller> createParserObjectFactory(IPropertyMapper propertyMapper) {
        return new EntityPropertyFillerFactory(propertyMapper);
    }

    static abstract class AbstractAssignPropertyTypeParameters
    extends AbstractParameters
    implements IEntityTypeCodeProvider {
        public static final String PROPERTY_CODE_GENERIC_ARG_LABEL = "<property-code>";
        @Option(name="g", longName="global", metaVar="global-value", usage="Global default value for entities that are not specified in an external file.")
        private String globalValue;
        @Option(name="m", longName="mandatory", metaVar="is-mandatory", usage="Should the value for this property be always specified?")
        private boolean isMandatory;
        private final EntityKind entityKind;
        private String filePath;

        AbstractAssignPropertyTypeParameters(String[] args, String commandName, EntityKind entityKind, String entityCodeGenericArgLabel) {
            super(args, commandName, AbstractAssignPropertyTypeParameters.getGenericArgs(entityCodeGenericArgLabel, PROPERTY_CODE_GENERIC_ARG_LABEL));
            this.entityKind = entityKind;
            int size = this.getArgs().size();
            int count = this.getArgCount();
            if (size < count) {
                System.err.println(this.getTooFewArgumentsErrorMessage());
                this.printHelp(true);
            } else if (size > count) {
                System.err.println("Too many parameters");
                this.printHelp(true);
            }
        }

        public static final String getGenericArgs(String ... genericArgs) {
            StringBuilder builder = new StringBuilder();
            String[] stringArray = genericArgs;
            int n = genericArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String genericArg = stringArray[n2];
                if (genericArg != null) {
                    if (builder.length() > 0) {
                        builder.append(' ');
                    }
                    builder.append(genericArg);
                }
                ++n2;
            }
            return builder.toString();
        }

        private final File tryGetFile() {
            if (this.filePath == null) {
                return null;
            }
            return Utilities.getFileCheckAccesible(this.filePath);
        }

        static final String getEntityCodeGenericArgLabel(EntityKind entityKind) {
            return "<" + entityKind.getLabel() + "-type-code>";
        }

        final String getPropertyName() {
            return this.getArgs().get(this.getArgCount() - 1);
        }

        final boolean isMandatory() {
            return this.isMandatory;
        }

        final String getGlobalValue() {
            return this.globalValue;
        }

        String getTooFewArgumentsErrorMessage() {
            return "Specify the " + this.entityKind.getLabel() + " type and the code of the property, which should be assigned to it!";
        }

        void setFile(String filePath) {
            this.filePath = filePath;
        }

        int getArgCount() {
            return 2;
        }

        public String getEntityTypeCode() {
            return StringUtils.upperCase(this.getArgs().get(0));
        }
    }
}

