/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityPropertySchema;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.commands.IEntityTypeCodeProvider;
import ch.systemsx.cisd.lims.client.model.PropertySchemaTableModel;
import ch.systemsx.cisd.lims.client.parameters.OutputTypeParameters;

public abstract class AbstractGetEntityTypeInfoCommand
extends AbstractCommandWithSessionToken {
    static final String NO_PROPERTIES_ERROR_FORMAT = "No properties have been assigned to %s type %s";

    AbstractGetEntityTypeInfoCommand(String name) {
        super(name);
    }

    protected final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        AbstractEntityTypeParameters parameters = this.getParameters(arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        String entityTypeCode = parameters.getEntityTypeCode();
        SimpleEntityPropertySchema[] schemas = limsService.listEntityPropertyTypes(sessionToken, this.getEntityType(), entityTypeCode);
        if (schemas.length == 0 && parameters.isPrettyPrinted()) {
            System.out.println(String.format(NO_PROPERTIES_ERROR_FORMAT, this.getEntityType().getLabel(), entityTypeCode));
            return 0;
        }
        String header = "Properties of " + this.getEntityType().getLabel() + "s of type " + entityTypeCode;
        PropertySchemaTableModel tableModel = new PropertySchemaTableModel(schemas, header, parameters.isPrettyPrinted());
        this.printTable(tableModel, parameters);
        return 0;
    }

    abstract AbstractEntityTypeParameters getParameters(String[] var1);

    abstract EntityKind getEntityType();

    static abstract class AbstractEntityTypeParameters
    extends OutputTypeParameters
    implements IEntityTypeCodeProvider {
        public AbstractEntityTypeParameters(String[] args, String limsCommandName, String genericArgs) {
            super(args, limsCommandName, genericArgs);
        }

        public String getEntityTypeCode() {
            return this.getArgs().get(0);
        }
    }
}

