/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.Invalidation;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.output.IOutputPrinter;
import ch.systemsx.cisd.lims.client.utilities.PersonDescriptor;
import ch.systemsx.cisd.lims.client.utilities.Utilities;
import java.util.Date;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractInvalidationInfoCommand
extends AbstractCommandWithSessionToken {
    AbstractInvalidationInfoCommand(String name) {
        super(name);
    }

    protected void printInvalidation(IOutputPrinter printer, Invalidation invalidationOrNull, boolean prettyMode) {
        printer.printKeyValuePair(FieldName.INVALIDATED.getName(prettyMode), invalidationOrNull == null ? BooleanUtils.toStringYesNo(false) : BooleanUtils.toStringYesNo(true));
        if (invalidationOrNull == null) {
            return;
        }
        Date registrationDate = invalidationOrNull.getRegistrationDate();
        Person registrator = invalidationOrNull.getRegistrator();
        PersonDescriptor.printKeyValueInvalidator(printer, registrator, prettyMode);
        printer.printKeyValuePair(FieldName.INVALIDATION_DATE.getName(prettyMode), Utilities.formatDate(registrationDate));
        if (StringUtils.isNotEmpty(invalidationOrNull.getReason())) {
            printer.printKeyValuePair(FieldName.INVALIDATION_REASON.getName(prettyMode), invalidationOrNull.getReason());
        }
    }
}

