/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.StringUtilities;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.PropertyTypeEntityTypeRelation;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.model.PropertyRelationTableModel;
import ch.systemsx.cisd.lims.client.parameters.EmptyParameters;
import ch.systemsx.cisd.lims.client.parameters.OutputTypeParameters;

public abstract class AbstractListEntityPropertyTypesCommand
extends AbstractCommandWithSessionToken {
    private static final String NO_ENTITY_PROPERTY_RELATION = "No property types found for %s";

    AbstractListEntityPropertyTypesCommand(String name) {
        super(name);
    }

    PropertyTypeEntityTypeRelation[] listPropertyTypeRelations(String sessionToken, ILIMSService limsService, EntityKind entityKind) {
        return limsService.listPropertyTypeRelations(sessionToken, entityKind);
    }

    String getEntityKindLabel(EntityKind entityKind) {
        return StringUtilities.capitalize(entityKind.getLabel());
    }

    PropertyRelationTableModel createTableModel(OutputTypeParameters parameters, PropertyTypeEntityTypeRelation[] relations, String entityKindLabel) {
        return new PropertyRelationTableModel(relations, entityKindLabel, parameters.isPrettyPrinted());
    }

    protected final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        OutputTypeParameters parameters = new OutputTypeParameters(arguments, this.getName());
        EmptyParameters.assertArgsEmpty(parameters);
        ILIMSService limsService = this.getLIMSService(parameters);
        EntityKind entityKind = this.getEntityKind();
        PropertyTypeEntityTypeRelation[] relations = this.listPropertyTypeRelations(sessionToken, limsService, entityKind);
        String entityKindLabel = this.getEntityKindLabel(entityKind);
        if (relations.length == 0 && parameters.isPrettyPrinted()) {
            System.out.println(String.format(NO_ENTITY_PROPERTY_RELATION, entityKindLabel));
        } else {
            this.printTable(this.createTableModel(parameters, relations, entityKindLabel), parameters);
        }
        return 0;
    }

    abstract EntityKind getEntityKind();
}

