/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.IEntityType;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.model.EntityTypeTableModel;
import ch.systemsx.cisd.lims.client.parameters.OutputTypeParameters;
import java.util.Arrays;

abstract class AbstractListTypesCommand
extends AbstractCommandWithSessionToken {
    AbstractListTypesCommand(String name) {
        super(name);
    }

    protected int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        OutputTypeParameters parameters = new OutputTypeParameters(arguments, this.getName());
        ILIMSService limsService = this.getLIMSService(parameters);
        IEntityType[] materialTypes = this.listTypes(limsService, sessionToken);
        int numberOfMaterialTypes = materialTypes.length;
        if (numberOfMaterialTypes == 0 && parameters.isPrettyPrinted()) {
            System.out.println("No " + this.getNameOfType() + " types have been found in the database.");
            return 0;
        }
        this.sortByCode(materialTypes);
        EntityTypeTableModel model = new EntityTypeTableModel(materialTypes, null, parameters.isPrettyPrinted());
        this.printTable(model, parameters);
        return 0;
    }

    private void sortByCode(IEntityType[] materialTypes) {
        Arrays.sort(materialTypes);
    }

    protected abstract String getNameOfType();

    protected abstract IEntityType[] listTypes(ILIMSService var1, String var2);
}

