/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.IPropertiesSetter;
import ch.systemsx.cisd.lims.base.IEntityPropertiesHolder;
import ch.systemsx.cisd.lims.base.properties.EntityDataType;
import ch.systemsx.cisd.lims.base.properties.EntityProperties;
import ch.systemsx.cisd.lims.base.properties.EntityPropertySchema;
import ch.systemsx.cisd.lims.base.properties.EntityPropertyValue;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractPropertiesSetter<T extends IEntityPropertiesHolder>
implements IPropertiesSetter<T> {
    private static final SimpleDateFormat SECONDS_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat MINUTES_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final SimpleDateFormat DAYS_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final Map<String, String> lowerCaseCodeToCodeMap;
    private final IEntityPropertiesSchema schema;
    private final EntityProperties properties;

    AbstractPropertiesSetter(IEntityPropertiesSchema schema) {
        assert (schema != null) : "Unspecified entity properties schema.";
        this.lowerCaseCodeToCodeMap = new LinkedHashMap<String, String>();
        String[] stringArray = schema.getAllNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            EntityPropertySchema propertySchema = schema.getPropertySchema(name);
            this.lowerCaseCodeToCodeMap.put(propertySchema.getCode().toLowerCase(), name);
            ++n2;
        }
        this.schema = schema;
        this.properties = new EntityProperties(schema);
    }

    protected abstract T createEntityPropertiesHolder();

    protected abstract void checkSpecificMandatoryConstraints();

    protected abstract boolean setSpecificProperty(String var1, String var2);

    private final void checkMandatoryConstraint() {
        this.checkSpecificMandatoryConstraints();
        this.checkPropertiesMandatoryConstraint();
    }

    private final void checkPropertiesMandatoryConstraint() {
        String[] stringArray = this.schema.getAllNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            EntityPropertySchema propertySchema = this.schema.getPropertySchema(name);
            if (propertySchema.getIsMandatory() && !this.properties.hasProperty(name)) {
                throw new UserFailureException("No entity property value for '" + name + "'.");
            }
            ++n2;
        }
    }

    private static final String tryNormalizeValue(String name, String valueOrNull, IEntityPropertiesSchema schema) {
        if (valueOrNull == null) {
            return valueOrNull;
        }
        EntityDataType dataType = schema.getPropertySchema(name).getDataTypeCode();
        if (dataType.equals(EntityDataType.DATE)) {
            return AbstractPropertiesSetter.normalizeDate(valueOrNull);
        }
        if (dataType.equals(EntityDataType.VOCABULARY)) {
            return valueOrNull.toUpperCase();
        }
        return valueOrNull;
    }

    private static final String normalizeDate(String untypedDate) {
        SimpleDateFormat[] formats;
        String normalizedDate = null;
        SimpleDateFormat[] simpleDateFormatArray = formats = new SimpleDateFormat[]{EntityPropertyValue.CANONICAL_DATE_FORMAT, SECONDS_DATE_FORMAT, MINUTES_DATE_FORMAT, DAYS_DATE_FORMAT};
        int n = formats.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleDateFormat dateFormat = simpleDateFormatArray[n2];
            normalizedDate = AbstractPropertiesSetter.tryNormalizeDate(untypedDate, dateFormat);
            if (normalizedDate != null) {
                return normalizedDate;
            }
            ++n2;
        }
        throw AbstractPropertiesSetter.createIncorrectDateFormatException(untypedDate, formats);
    }

    private static final UserFailureException createIncorrectDateFormatException(String dateCandidate, SimpleDateFormat[] formats) {
        String availFormatsDesc = AbstractPropertiesSetter.createFormatsDescription(formats);
        return UserFailureException.fromTemplate("Date value '%s' has improper format. The proper formats are: %s.", dateCandidate, availFormatsDesc);
    }

    private static final String createFormatsDescription(SimpleDateFormat[] formats) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < formats.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(formats[i].toPattern());
            ++i;
        }
        return sb.toString();
    }

    private static final String tryNormalizeDate(String untypedDate, SimpleDateFormat dateFormat) {
        try {
            Date date = dateFormat.parse(untypedDate);
            return EntityPropertyValue.createDate(date).tryGetUntypedValue();
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public final T getConstructedObject() {
        this.checkMandatoryConstraint();
        T constructed = this.createEntityPropertiesHolder();
        constructed.setProperties(this.properties.createSimple());
        return constructed;
    }

    @Override
    public final void setProperty(String name, String value) {
        String valueOrNull = StringUtils.isBlank(value) ? null : value;
        String nameInLowerCase = name.toLowerCase();
        boolean successful = this.setSpecificProperty(nameInLowerCase, valueOrNull);
        if (successful) {
            return;
        }
        String propertyName = this.lowerCaseCodeToCodeMap.get(nameInLowerCase);
        if (propertyName == null) {
            throw new UserFailureException("Unknown column name '" + name + "'.");
        }
        valueOrNull = AbstractPropertiesSetter.tryNormalizeValue(propertyName, valueOrNull, this.schema);
        this.properties.setProperty(propertyName, valueOrNull);
    }
}

