/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.ExperimentFileAttachment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.FileProperty;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.parameters.AbstractExperimentParameters;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;

public class AddExperimentAttachmentCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "add-experiment-attachment";
    private static AddExperimentAttachmentCommand instance;

    private AddExperimentAttachmentCommand() {
        super(NAME);
    }

    public static final synchronized AddExperimentAttachmentCommand getInstance() {
        if (instance == null) {
            instance = new AddExperimentAttachmentCommand();
        }
        return instance;
    }

    public final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifier(parameters.getProjectCode(), parameters.getExperimentCode());
        File propertyFile = new File(parameters.getPropertyPathname());
        byte[] propertyContent = AddExperimentAttachmentCommand.tryLoadFileContent(propertyFile);
        if (propertyContent == null) {
            return 1;
        }
        ILIMSService limsService = this.getLIMSService(parameters);
        limsService.addExperimentFileAttachment(sessionToken, experimentIdentifier, AddExperimentAttachmentCommand.createProperty(propertyFile, propertyContent));
        System.out.println(String.format("Successfully stored attachment '%s' for experiment '%s'.", propertyFile.getAbsolutePath(), experimentIdentifier));
        return 0;
    }

    private static ExperimentFileAttachment createProperty(File propertyFile, byte[] propertyContent) {
        ExperimentFileAttachment property = new ExperimentFileAttachment();
        FileProperty fileProperty = new FileProperty();
        property.setFileProperty(fileProperty);
        fileProperty.setFileName(propertyFile.getName());
        try {
            property.setValue(new String(Base64.encodeBase64((byte[])propertyContent), "ASCII"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new CheckedExceptionTunnel(ex);
        }
        return property;
    }

    private static byte[] tryLoadFileContent(File propertyFile) {
        try {
            return FileUtils.readFileToByteArray((File)propertyFile);
        }
        catch (IOException ex) {
            System.err.println("Could not read file '" + propertyFile.getAbsolutePath() + "' (" + ex.getMessage() + ").");
            return null;
        }
    }

    private static final class Parameters
    extends AbstractExperimentParameters {
        public Parameters(String[] args) {
            this(args, SystemExit.SYSTEM_EXIT);
        }

        Parameters(String[] args, IExitHandler exitHandler) {
            super(args, AddExperimentAttachmentCommand.NAME, "<project-code> <experiment-code> <file-name>", exitHandler);
            if (this.getArgs().size() != 3) {
                System.err.println("There needs to be exactly one <project-code>, one <experiment-code> and one <file-name>.");
                this.printHelp(true);
            }
        }

        final String getPropertyPathname() {
            return this.getArgs().get(2);
        }
    }
}

