/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.collections.CollectionStyle;
import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IndexOutOfBoundsException;
import ch.systemsx.cisd.common.parser.MandatoryPropertyMissingException;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.ParsingException;
import ch.systemsx.cisd.common.parser.TabFileLoader;
import ch.systemsx.cisd.common.parser.UnmatchedPropertiesException;
import ch.systemsx.cisd.common.utilities.StringUtilities;
import java.io.File;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BisTabFileLoader<T>
extends TabFileLoader<T> {
    private static final String MESSAGE_FORMAT = "A problem has occurred while parsing line %d of file '%s':\n  %s";

    public BisTabFileLoader(IParserObjectFactoryFactory<T> factory) {
        super(factory);
    }

    private static final String getMessage(ParserException parserException) {
        if (parserException instanceof MandatoryPropertyMissingException) {
            return BisTabFileLoader.getMessage((MandatoryPropertyMissingException)parserException);
        }
        if (parserException instanceof UnmatchedPropertiesException) {
            return BisTabFileLoader.getMessage((UnmatchedPropertiesException)parserException);
        }
        if (parserException instanceof IndexOutOfBoundsException) {
            return BisTabFileLoader.getMessage((IndexOutOfBoundsException)parserException);
        }
        return parserException.getMessage();
    }

    private static final String getMessage(IndexOutOfBoundsException exception) {
        String[] lineTokens = exception.getLineTokens();
        return String.format("Not enough columns available. Looking for %s column but we have only %d columns (%s).", StringUtilities.getOrdinal(exception.getColumn() + 1), lineTokens.length, CollectionUtils.abbreviate(lineTokens, -1, CollectionStyle.SINGLE_QUOTE_BOUNDARY));
    }

    private static final String getMessage(UnmatchedPropertiesException exception) {
        boolean hasMandatory;
        StringBuilder builder = new StringBuilder();
        builder.append("Columns ").append(BisTabFileLoader.toString(exception.getPropertyNames())).append(" specified in the header are not expected (");
        Set<String> mandatoryNames = exception.getMandatoryNames();
        Set<String> optionalNames = exception.getOptionalNames();
        boolean bl = hasMandatory = mandatoryNames.size() > 0;
        if (hasMandatory) {
            builder.append("mandatory colums are ");
            builder.append(BisTabFileLoader.toString(mandatoryNames));
        }
        if (optionalNames.size() > 0) {
            if (hasMandatory) {
                builder.append(", ");
            }
            builder.append("optional colums are ");
            builder.append(BisTabFileLoader.toString(optionalNames));
        }
        builder.append(")");
        return builder.toString();
    }

    private static final String getMessage(MandatoryPropertyMissingException exception) {
        return String.format("Mandatory column(s) %s are missing (mandatory columns are %s).", BisTabFileLoader.toString(exception.getMissingMandatoryProperties()), BisTabFileLoader.toString(exception.getMandatoryFields()));
    }

    private static final String toString(Set<String> set) {
        return CollectionUtils.abbreviate(set, -1, CollectionStyle.SINGLE_QUOTE_BOUNDARY);
    }

    private static final String getCauseMessage(RuntimeException runtimeException) {
        if (runtimeException instanceof ParserException) {
            return BisTabFileLoader.getMessage((ParserException)runtimeException);
        }
        return runtimeException.getMessage();
    }

    @Override
    public final List<T> load(File file) {
        try {
            if (!file.exists()) {
                throw new UserFailureException("Given file '" + file.getAbsolutePath() + "' does not exist or is not a file.");
            }
            return super.load(file);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UserFailureException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (ParserException parserException) {
            throw new UserFailureException(BisTabFileLoader.getMessage(parserException), parserException);
        }
    }

    @Override
    protected final void throwParsingException(ParsingException parsingException, File file) {
        RuntimeException causeException = parsingException.getCauseRuntimeException();
        String message = causeException == null ? parsingException.getMessage() : BisTabFileLoader.getCauseMessage(causeException);
        throw UserFailureException.fromTemplate(MESSAGE_FORMAT, parsingException.getLineNumber(), file, message);
    }
}

