/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertiesSetter;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyObjectFactory;
import ch.systemsx.cisd.common.parser.filter.ExcludeEmptyAndCommentLineFilter;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.lims.base.NewExperiment;
import ch.systemsx.cisd.lims.base.ProcessingInstruction;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import ch.systemsx.cisd.lims.client.commands.AbstractPropertiesSetter;
import ch.systemsx.cisd.lims.client.commands.BisTabFileLoader;
import ch.systemsx.cisd.lims.client.commands.factory.AbstractFileBasedConverter;
import ch.systemsx.cisd.lims.client.commands.factory.ProcessingInstructionFactory;
import java.io.File;
import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExperimentPropertiesSetter
extends AbstractPropertiesSetter<NewExperiment> {
    private static final String PROP_CODE = "code";
    private static final String PROP_DESC = "description";
    private static final String PROP_CONTROL_LAYOUT = "control_layout";
    private static final String PROP_CELL_PLATES = "cell_plates";
    private static final String PROP_PROC_INSTRS = "processing_instructions";
    private static final String PROP_STUDY_OBJ = "study_object";
    private static final String PROP_PROJ_CODE = "project";
    private static final String PROP_STUDY_OBJ_TYPE = "study_object_type";
    private final CellPlatesConverter cellPlatesConverter;
    private final ProcessingInstructionsConverter processingInstructionsConverter;
    private final NewExperiment result;

    public static IPropertyObjectFactory<NewExperiment> createFactory(final String experimentTypeCode, final File rootDir, final IEntityPropertiesSchema schema) {
        return new IPropertyObjectFactory<NewExperiment>(){

            @Override
            public final IPropertiesSetter<NewExperiment> createObjectSetter() {
                return new ExperimentPropertiesSetter(experimentTypeCode, rootDir, schema, null);
            }
        };
    }

    private ExperimentPropertiesSetter(String experimentTypeCode, File rootDir, IEntityPropertiesSchema schema) {
        super(schema);
        this.cellPlatesConverter = new CellPlatesConverter(rootDir);
        this.processingInstructionsConverter = new ProcessingInstructionsConverter(rootDir);
        this.result = new NewExperiment();
        this.result.setExperimentTypeCode(experimentTypeCode);
        this.result.setProcessingInstructions(this.processingInstructionsConverter.getDefaultValue());
        this.result.setCellPlates(this.cellPlatesConverter.getDefaultValue());
    }

    @Override
    protected final void checkSpecificMandatoryConstraints() {
        if (this.result.getStudyObjectCode() == null) {
            throw new UserFailureException("Study object code has to be provided.");
        }
        if (this.result.getProjectCode() == null) {
            throw new UserFailureException("Project code has to be provided.");
        }
        if (this.result.getStudyObjectTypeCode() == null) {
            throw new UserFailureException("Study object type code has to be provided.");
        }
    }

    @Override
    protected final NewExperiment createEntityPropertiesHolder() {
        return this.result;
    }

    @Override
    protected final boolean setSpecificProperty(String name, String valueOrNull) {
        boolean successful = true;
        if (name.equalsIgnoreCase(PROP_CODE)) {
            this.result.setCode(valueOrNull);
        } else if (name.equalsIgnoreCase(PROP_CELL_PLATES)) {
            String[] cellPlates = (String[])this.cellPlatesConverter.convert(valueOrNull);
            this.result.setCellPlates(cellPlates);
        } else if (name.equalsIgnoreCase(PROP_PROC_INSTRS)) {
            ProcessingInstruction[] processingInstrs = (ProcessingInstruction[])this.processingInstructionsConverter.convert(valueOrNull);
            this.result.setProcessingInstructions(processingInstrs);
        } else if (name.equalsIgnoreCase(PROP_CONTROL_LAYOUT)) {
            this.result.setControlLayoutCode(valueOrNull);
        } else if (name.equalsIgnoreCase(PROP_DESC)) {
            this.result.setDescription(valueOrNull);
        } else if (name.equalsIgnoreCase(PROP_PROJ_CODE)) {
            this.result.setProjectCode(valueOrNull);
        } else if (name.equalsIgnoreCase(PROP_STUDY_OBJ)) {
            this.result.setStudyObjectCode(valueOrNull);
        } else if (name.equalsIgnoreCase(PROP_STUDY_OBJ_TYPE)) {
            this.result.setStudyObjectTypeCode(valueOrNull);
        } else {
            successful = false;
        }
        return successful;
    }

    /* synthetic */ ExperimentPropertiesSetter(String string, File file, IEntityPropertiesSchema iEntityPropertiesSchema, ExperimentPropertiesSetter experimentPropertiesSetter) {
        this(string, file, iEntityPropertiesSchema);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CellPlatesConverter
    extends AbstractFileBasedConverter<String[]> {
        CellPlatesConverter(File rootDir) {
            super(rootDir);
        }

        @Override
        protected final String[] convert(File file) {
            return FileUtilities.loadToStringList(file, ExcludeEmptyAndCommentLineFilter.INSTANCE).toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        }

        @Override
        public final String[] getDefaultValue() {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProcessingInstructionsConverter
    extends AbstractFileBasedConverter<ProcessingInstruction[]> {
        private static final ProcessingInstruction[] PROCESSING_INSTRUCTION_EMPTY_ARRAY = new ProcessingInstruction[0];

        ProcessingInstructionsConverter(File rootDir) {
            super(rootDir);
        }

        @Override
        protected final ProcessingInstruction[] convert(final File file) {
            BisTabFileLoader<ProcessingInstruction> tabFileLoader = new BisTabFileLoader<ProcessingInstruction>(new IParserObjectFactoryFactory<ProcessingInstruction>(){

                @Override
                public final IParserObjectFactory<ProcessingInstruction> createFactory(IPropertyMapper propertyMapper) {
                    ProcessingInstructionFactory experimentFactory = ProcessingInstructionFactory.createInstance(propertyMapper, file.getParentFile());
                    return experimentFactory;
                }
            });
            return tabFileLoader.load(file).toArray(PROCESSING_INSTRUCTION_EMPTY_ARRAY);
        }

        @Override
        public final ProcessingInstruction[] getDefaultValue() {
            return PROCESSING_INSTRUCTION_EMPTY_ARRAY;
        }
    }
}

