/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.BaseExperiment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.MoleculeCriteria;
import ch.systemsx.cisd.lims.base.PlateLocation;
import ch.systemsx.cisd.lims.base.QueryRestriction;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.base.SampleComponent;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.parameters.AbstractExperimentFilterParameter;
import ch.systemsx.cisd.lims.client.utilities.Utilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GetPlateLocationsCommand
extends AbstractCommandWithSessionToken {
    static final String NO_GENE_CODE_SPECIFIED = "There needs to be exactly one gene symbol (or gene id).";
    private static final String NAME = "get-plate-locations";
    private static final String NO_PLATE_LOCATIONS_FOR_EXPERIMENT = "No plate locations could be found for experiment %s.";
    private static GetPlateLocationsCommand instance;

    private GetPlateLocationsCommand() {
        super(NAME);
    }

    public static final synchronized GetPlateLocationsCommand getInstance() {
        if (instance == null) {
            instance = new GetPlateLocationsCommand();
        }
        return instance;
    }

    @Override
    public int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        String geneCode = parameters.getGeneCode();
        ExperimentIdentifier experimentIdentifier = parameters.getExperimentIdentifier();
        QueryRestriction queryRestriction = parameters.getQueryRestriction();
        ArrayList<ExperimentIdentifier> experimentIdentifiers = new ArrayList<ExperimentIdentifier>();
        if (experimentIdentifier == null) {
            BaseExperiment[] experiments;
            BaseExperiment[] baseExperimentArray = experiments = limsService.listExperiments(sessionToken, queryRestriction);
            int n = experiments.length;
            int n2 = 0;
            while (n2 < n) {
                BaseExperiment experiment = baseExperimentArray[n2];
                String projectCode = experiment.getProject().getCode();
                String experimentCode = experiment.getCode();
                experimentIdentifiers.add(new ExperimentIdentifier(projectCode, experimentCode));
                ++n2;
            }
            if (experimentIdentifiers.isEmpty()) {
                String info = Utilities.createMessageInfoSnippet(queryRestriction);
                System.out.println("No experiments has been found" + info + ".");
            }
        } else {
            experimentIdentifiers.add(experimentIdentifier);
        }
        boolean symbolic = parameters.isSymbolic();
        this.printPlateLocations(sessionToken, limsService, experimentIdentifiers, geneCode, symbolic, parameters.getShowIvalidated());
        return 0;
    }

    private void printPlateLocations(String sessionToken, ILIMSService limsService, List<ExperimentIdentifier> experiments, String geneCode, boolean symbolic, boolean showInvalidated) {
        for (ExperimentIdentifier experimentIdentifier : experiments) {
            MoleculeCriteria criteria = new MoleculeCriteria();
            if (!symbolic) {
                criteria.setTypeCode("GENE");
                criteria.setCode(geneCode);
            } else {
                criteria.setGeneSymbol(geneCode);
            }
            Object[] plateLocations = limsService.getPlateLocations(sessionToken, experimentIdentifier, criteria, showInvalidated);
            if (plateLocations.length == 0) {
                GetPlateLocationsCommand.printNoPlateLocationsForExperimentFound(geneCode, symbolic, experimentIdentifier);
                continue;
            }
            Arrays.sort(plateLocations);
            GetPlateLocationsCommand.printPlateLocations((PlateLocation[])plateLocations, experimentIdentifier, geneCode, symbolic, showInvalidated);
        }
    }

    private static void printNoPlateLocationsForExperimentFound(String geneCode, boolean symbolic, ExperimentIdentifier experimentIdentifier) {
        StringBuilder description = GetPlateLocationsCommand.createDescription(experimentIdentifier, geneCode, symbolic);
        System.out.println(String.format(NO_PLATE_LOCATIONS_FOR_EXPERIMENT, description));
    }

    private static final void printPlateLocations(PlateLocation[] plateLocations, ExperimentIdentifier experimentIdentifier, String geneCode, boolean symbolic, boolean showInvalidated) {
        StringBuilder description = GetPlateLocationsCommand.createDescription(experimentIdentifier, geneCode, symbolic);
        System.out.println(String.format("<<<Plate locations for experiment %s>>>", description));
        PlateLocation[] plateLocationArray = plateLocations;
        int n = plateLocations.length;
        int n2 = 0;
        while (n2 < n) {
            PlateLocation location = plateLocationArray[n2];
            if (showInvalidated || !location.isMasterPlateInvalidated()) {
                System.out.println(String.valueOf(INDENTATION) + "Master Plate '" + location.getMasterPlateCode() + "'" + (location.isMasterPlateInvalidated() ? " (invalid)" : ""));
                GetPlateLocationsCommand.printPlateComponents(location.getSampleComponents(), StringUtils.repeat(INDENTATION, 2));
                GetPlateLocationsCommand.printPlates(location.getSamples(), StringUtils.repeat(INDENTATION, 2));
            }
            ++n2;
        }
    }

    private static StringBuilder createDescription(ExperimentIdentifier experimentIdentifier, String geneCode, boolean symbolic) {
        StringBuilder builder = new StringBuilder();
        builder.append(experimentIdentifier).append(" and ").append(symbolic ? "gene" : "gene with ID");
        builder.append(" '").append(geneCode).append("'");
        return builder;
    }

    private static final void printPlates(Sample[] plates, String indent) {
        System.out.println(String.valueOf(indent) + "Plate code(s):");
        Sample[] sampleArray = plates;
        int n = plates.length;
        int n2 = 0;
        while (n2 < n) {
            Sample plate = sampleArray[n2];
            String invalidated = plate.getInvalidation() != null ? " (invalid)" : "";
            System.out.println(String.valueOf(indent) + INDENTATION + plate.getCode() + invalidated);
            ++n2;
        }
    }

    private static void printPlateComponents(SampleComponent[] sampleComponents, String indent) {
        System.out.println(String.valueOf(indent) + "Well code(s):");
        StringBuilder builder = new StringBuilder();
        SampleComponent[] sampleComponentArray = sampleComponents;
        int n = sampleComponents.length;
        int n2 = 0;
        while (n2 < n) {
            SampleComponent sampleComponent = sampleComponentArray[n2];
            builder.setLength(0);
            builder.append(indent).append(INDENTATION).append(sampleComponent.getCode());
            builder.append("[").append("Oligo").append("=");
            builder.append(sampleComponent.getMaterialBatch().getMaterial().getCode()).append("]");
            System.out.println(builder);
            ++n2;
        }
    }

    private static final class Parameters
    extends AbstractExperimentFilterParameter {
        @Option(name="a", longName="show-also-invalid", usage="Returned results will contain also invalid plates")
        private boolean showInvalidated;
        @Option(name="i", longName="gene-id", usage="Gene is specified by its id and not by its symbol")
        private boolean byID;
        @Option(name="e", longName="experiment", metaVar="CODE", usage="Experiment code. If this option is specified the options for study object and time interval will be ignored.")
        private String experimentCode;

        Parameters(String[] args) {
            super(args, GetPlateLocationsCommand.NAME, "<gene-symbol or id>");
            if (this.getArgs().size() != 1) {
                System.err.println(GetPlateLocationsCommand.NO_GENE_CODE_SPECIFIED);
                this.printHelp(true);
            }
        }

        final ExperimentIdentifier getExperimentIdentifier() {
            String projectCode = this.getProjectCode();
            ExperimentIdentifier experimentIdentifier = null;
            if (projectCode != null && this.experimentCode != null) {
                experimentIdentifier = new ExperimentIdentifier();
                experimentIdentifier.setProjectCode(projectCode);
                experimentIdentifier.setExperimentCode(this.experimentCode);
            }
            return experimentIdentifier;
        }

        final String getGeneCode() {
            return this.getArgs().get(0);
        }

        final boolean isSymbolic() {
            return !this.byID;
        }

        final boolean getShowIvalidated() {
            return this.showInvalidated;
        }
    }
}

