/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.collections.FilteredList;
import ch.systemsx.cisd.common.collections.Validator;
import ch.systemsx.cisd.lims.base.IEntityType;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.SampleType;
import ch.systemsx.cisd.lims.client.commands.AbstractListTypesCommand;
import java.util.ArrayList;
import java.util.Arrays;

public final class ListPlateTypesCommand
extends AbstractListTypesCommand {
    private static final String NAME = "list-plate-types";
    private static ListPlateTypesCommand instance;

    private ListPlateTypesCommand() {
        super(NAME);
    }

    public static final synchronized ListPlateTypesCommand getInstance() {
        if (instance == null) {
            instance = new ListPlateTypesCommand();
        }
        return instance;
    }

    protected final String getNameOfType() {
        return "plate";
    }

    protected final IEntityType[] listTypes(ILIMSService limsService, String sessionToken) {
        SampleType[] sampleTypes = limsService.listSampleTypes(sessionToken);
        ArrayList sampleTypeList = new ArrayList(Arrays.asList(sampleTypes));
        return FilteredList.decorate(sampleTypeList, new Validator<SampleType>(){

            @Override
            public final boolean isValid(SampleType sampleType) {
                return !sampleType.isControlLayout();
            }
        }).toArray(SampleType.EMPTY_ARRAY);
    }
}

