/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.NewSampleComponentWithFixedMaterialType;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.client.commands.AbstractPropertiesFileParameters;
import ch.systemsx.cisd.lims.client.commands.AbstractRegisterTopPlateCommand;
import java.io.File;

public final class RegisterControlLayoutCommand
extends AbstractRegisterTopPlateCommand {
    static final String REGISTER_SUCCESSFUL_FORMAT = "  Control layout '%s' successfully registered.";
    static final String WRONG_ARGUMENTS_SIZE = "Exactly one control layout file must be specified.";
    private static final String REGISTER_START_FORMAT = "Register control layout from '%s'.";
    private static final String NAME = "register-control-layout";
    private static final String GENERIC_ARGS = "<control-layout-file>";
    private static RegisterControlLayoutCommand instance;

    private RegisterControlLayoutCommand() {
        super(NAME, SampleTypeCode.CONTROL_LAYOUT);
    }

    public static final synchronized RegisterControlLayoutCommand getInstance() {
        if (instance == null) {
            instance = new RegisterControlLayoutCommand();
        }
        return instance;
    }

    public final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments, NAME, GENERIC_ARGS);
        ILIMSService limsService = this.getLIMSService(parameters);
        File file = parameters.getFile();
        String canonical = FileUtilities.getCanonicalPath(file);
        String code = this.getSampleCode(canonical);
        System.out.println(String.format(REGISTER_START_FORMAT, canonical));
        NewSampleComponentWithFixedMaterialType[] sampleComponents = this.loadSampleComponentsWithFixedMaterialTypeFromTabFile(file);
        SimpleEntityProperty[] propertyValues = this.getPropertyValues(sessionToken, limsService, parameters);
        this.register(limsService, sessionToken, code, propertyValues, sampleComponents);
        System.out.println(String.format(REGISTER_SUCCESSFUL_FORMAT, code));
        return 0;
    }

    private final void register(ILIMSService limsService, String sessionToken, String sampleCode, SimpleEntityProperty[] propertyValues, NewSampleComponentWithFixedMaterialType[] components) {
        limsService.registerControlLayout(sessionToken, sampleCode, propertyValues, components);
    }

    private static final class Parameters
    extends AbstractPropertiesFileParameters {
        public Parameters(String[] args, String commandName, String genericArgs) {
            super(args, commandName, genericArgs, SystemExit.SYSTEM_EXIT);
            if (this.getArgs().size() != 1) {
                System.err.println(RegisterControlLayoutCommand.WRONG_ARGUMENTS_SIZE);
                this.printHelp(true);
            }
        }
    }
}

