/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.NewSampleComponent;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.client.commands.AbstractPropertiesFileParameters;
import ch.systemsx.cisd.lims.client.commands.AbstractRegisterTopPlateCommand;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.args4j.Option;

public final class RegisterMasterPlateCommand
extends AbstractRegisterTopPlateCommand {
    static final String REGISTER_SUCCESSFUL_FORMAT = "  Master plate '%s' successfully registered.";
    static final String NOT_ENOUGH_ARGUMENTS = "Wrong parameters. At least file path and material batch code must be specified.";
    private static final String NAME = "register-master-plate";
    private static RegisterMasterPlateCommand instance;

    private RegisterMasterPlateCommand() {
        super(NAME, SampleTypeCode.MASTER_PLATE);
    }

    public static final synchronized RegisterMasterPlateCommand getInstance() {
        if (instance == null) {
            instance = new RegisterMasterPlateCommand();
        }
        return instance;
    }

    public int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments, NAME);
        ILIMSService limsService = this.getLIMSService(parameters);
        File file = parameters.getFile();
        String canonical = FileUtilities.getCanonicalPath(file);
        String code = this.getSampleCode(canonical);
        System.out.println(String.format("Registering master plate, loading data from '%s'.", canonical));
        NewSampleComponent[] sampleComponents = this.loadSampleComponentsFromTabFile(file);
        SimpleEntityProperty[] propertyValues = this.getPropertyValues(sessionToken, limsService, parameters);
        this.register(limsService, sessionToken, code, propertyValues, sampleComponents, parameters);
        System.out.println(String.format(REGISTER_SUCCESSFUL_FORMAT, code));
        return 0;
    }

    private final void register(ILIMSService limsService, String sessionToken, String sampleCode, SimpleEntityProperty[] propertyValues, NewSampleComponent[] components, Parameters parameters) {
        limsService.registerMasterPlate(sessionToken, sampleCode, propertyValues, components, parameters.getMaterialBatchCode(), parameters.tryGetControlLayoutCode());
    }

    private static final class Parameters
    extends AbstractPropertiesFileParameters {
        @Option(name="c", longName="control-layout", metaVar="<control-layout-code>", usage="Code of the control layout which is associated with the master plate to be registered")
        private String controlLayout;

        public Parameters(String[] args, String commandName) {
            super(args, commandName, "<master-plate-file> <material-batch-code>", SystemExit.SYSTEM_EXIT);
            int argsSize = this.getArgs().size();
            if (argsSize < 2) {
                System.err.println(RegisterMasterPlateCommand.NOT_ENOUGH_ARGUMENTS);
                this.printHelp(true);
            } else if (argsSize > 2) {
                System.err.printf("Too many parameters.", new Object[0]);
                this.printHelp(true);
            }
        }

        final String getMaterialBatchCode() {
            return this.getArgs().get(1);
        }

        final String tryGetControlLayoutCode() {
            if (StringUtils.isNotBlank(this.controlLayout)) {
                return this.controlLayout;
            }
            return null;
        }
    }
}

