/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.commands.AbstractFileParameters;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.kohsuke.args4j.Option;

public class RegisterVocabularyCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "register-vocabulary";
    private static RegisterVocabularyCommand instance;

    private RegisterVocabularyCommand() {
        super(NAME);
    }

    public static final synchronized RegisterVocabularyCommand getInstance() {
        if (instance == null) {
            instance = new RegisterVocabularyCommand();
        }
        return instance;
    }

    public int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        String[] vocabularyTerms = this.tryParseTerms(parameters.getFile());
        if (vocabularyTerms == null) {
            return 1;
        }
        limsService.registerVocabulary(sessionToken, parameters.getVocabularyName(), parameters.tryGetVocabularyDesc(), vocabularyTerms);
        System.out.println(String.format("New controlled vocabulary set '%s' has been successfully registered with %d terms.", parameters.getVocabularyName(), vocabularyTerms.length));
        return 0;
    }

    private String[] tryParseTerms(File file) {
        try {
            return FileUtils.readLines((File)file).toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        }
        catch (IOException ex) {
            System.err.println("Cannot read file " + file.getPath() + ": " + ex.getMessage());
            return null;
        }
    }

    private static final class Parameters
    extends AbstractFileParameters {
        @Option(name="d", longName="description", metaVar="description", usage="Description of the controlled vocabulary set")
        private String description;

        public Parameters(String[] args) {
            this(args, SystemExit.SYSTEM_EXIT);
        }

        Parameters(String[] args, IExitHandler exitHandler) {
            super(args, RegisterVocabularyCommand.NAME, "<vocabulary-name> <vocabulary-terms-file>", exitHandler);
            if (this.getArgs().size() != 2) {
                System.err.println("Wrong number of parameters.");
                this.printHelp(true);
            }
        }

        final String getVocabularyName() {
            return this.getArgs().get(0);
        }

        public String tryGetVocabularyDesc() {
            return this.description;
        }

        protected int getFileArgumentIndex() {
            return 1;
        }
    }
}

