/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.ListSet;
import ch.systemsx.cisd.lims.client.table.AbstractTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListSetBasedTableModel
extends AbstractTableModel {
    private final String header;
    private final ListSet listSet;
    private final List<String> columnNames;
    private final int rowCount;

    public ListSetBasedTableModel(String header, ListSet listSet) {
        this.listSet = listSet;
        this.header = header;
        this.columnNames = new ArrayList<String>(listSet.getNamesOfNonEmptyColumns());
        Collections.sort(this.columnNames);
        this.rowCount = listSet.getRowCount();
    }

    @Override
    public final int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public final String getColumnName(int columnIndex) {
        this.assertColumnIndex(columnIndex);
        return this.columnNames.get(columnIndex);
    }

    @Override
    public final String getHeader() {
        return this.header;
    }

    @Override
    public final int getRowCount() {
        return this.rowCount;
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        return this.listSet.tryGetValueAt(this.getColumnName(columnIndex), rowIndex);
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }
}

