/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.ListSet;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.base.PlainMaterial;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlainMaterialTableModel
extends ModalTableModel {
    private static final int FIXED_COLUMNS_NUMBER = 3;
    private final PlainMaterial[] materials;
    private final String header;
    private final ListSet properties;
    private final String[] columnsOrder;

    public PlainMaterialTableModel(PlainMaterial[] materials, String header, boolean prettyMode) {
        super(prettyMode);
        this.materials = materials;
        this.header = header;
        this.properties = this.createTable(materials);
        this.columnsOrder = this.properties.getNamesOfNonEmptyColumns().toArray(new String[0]);
    }

    private final ListSet createTable(PlainMaterial[] plainMaterials) {
        ListSet table = new ListSet();
        PlainMaterial[] plainMaterialArray = plainMaterials;
        int n = plainMaterials.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleEntityProperty[] simpleEntityPoperties;
            PlainMaterial material = plainMaterialArray[n2];
            SimpleEntityProperty[] simpleEntityPropertyArray = simpleEntityPoperties = material.getProperties();
            int n3 = simpleEntityPoperties.length;
            int n4 = 0;
            while (n4 < n3) {
                SimpleEntityProperty property = simpleEntityPropertyArray[n4];
                String name = this.prettyMode ? property.getUserLabel() : property.getCode();
                table.addToList(name, property.getUntypedValue());
                ++n4;
            }
            ++n2;
        }
        return table;
    }

    private final int getPropertyIndex(int columnIndex) {
        int ix = columnIndex - 3;
        if (ix >= this.columnsOrder.length) {
            throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
        }
        return ix;
    }

    private final String getPropertyName(int columnIndex) {
        int propertyIndex = this.getPropertyIndex(columnIndex);
        return this.columnsOrder[propertyIndex];
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return Person.class;
            }
            case 2: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public final int getColumnCount() {
        return 3 + this.columnsOrder.length;
    }

    @Override
    public final String getColumnName(int columnIndex) {
        if (columnIndex < 3) {
            return this.getFixedColumnName(columnIndex);
        }
        return this.getPropertyName(columnIndex);
    }

    protected String getFixedColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.CODE.getName(this.prettyMode);
            }
            case 1: {
                return FieldName.REGISTRATOR.getName(this.prettyMode);
            }
            case 2: {
                return FieldName.REGISTRATION_DATE.getName(this.prettyMode);
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    @Override
    public final String getHeader() {
        return this.header;
    }

    @Override
    public final int getRowCount() {
        return this.materials.length;
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        PlainMaterial material = this.materials[rowIndex];
        switch (columnIndex) {
            case 0: {
                return material.getCode();
            }
            case 1: {
                return material.getRegistrator();
            }
            case 2: {
                return material.getRegistrationDate();
            }
        }
        String name = this.getPropertyName(columnIndex);
        return this.properties.tryGetValueAt(name, rowIndex);
    }
}

