/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.common.collections.CollectionStyle;
import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.common.collections.IToStringConverter;
import ch.systemsx.cisd.lims.base.EntityTypeMandatorilyRelation;
import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.base.PropertyTypeEntityTypeRelation;
import ch.systemsx.cisd.lims.base.properties.PropertyType;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;
import ch.systemsx.cisd.lims.client.model.PropertiesDescriptor;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyRelationTableModel
extends ModalTableModel {
    private final String entityKindLabel;
    protected final PropertyTypeEntityTypeRelation[] relations;

    public PropertyRelationTableModel(PropertyTypeEntityTypeRelation[] relations, String entityKindLabel, boolean prettyMode) {
        super(prettyMode);
        this.relations = relations;
        this.entityKindLabel = entityKindLabel;
        Arrays.sort(relations);
    }

    private static final String getRelations(PropertyTypeEntityTypeRelation relation) {
        Object[] entityTypeRelations = relation.getRelations();
        if (entityTypeRelations.length < 1) {
            return null;
        }
        Arrays.sort(entityTypeRelations);
        return CollectionUtils.abbreviate(entityTypeRelations, -1, new EntityTypeMandatorilyRelationConverter(), CollectionStyle.NO_BOUNDARY);
    }

    private final String entityTypesColumnName() {
        String entity = this.entityKindLabel;
        String separator = " ";
        if (!this.prettyMode) {
            entity = StringUtils.upperCase(entity);
            separator = "_";
        }
        return String.valueOf(entity) + separator + FieldName.TYPES.getName(this.prettyMode);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 4: {
                return Person.class;
            }
            case 5: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public final String getHeader() {
        return "Property Types";
    }

    @Override
    public final int getRowCount() {
        return this.relations.length;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.CODE.getName(this.prettyMode);
            }
            case 1: {
                return FieldName.LABEL.getName(this.prettyMode);
            }
            case 2: {
                return FieldName.DATA_TYPE.getName(this.prettyMode);
            }
            case 3: {
                return this.entityTypesColumnName();
            }
            case 4: {
                return FieldName.REGISTRATOR.getName(this.prettyMode);
            }
            case 5: {
                return FieldName.REGISTRATION_DATE.getName(this.prettyMode);
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PropertyTypeEntityTypeRelation relation = this.relations[rowIndex];
        PropertyType property = relation.getProperty();
        switch (columnIndex) {
            case 0: {
                return property.getCode();
            }
            case 1: {
                return property.getUserLabel();
            }
            case 2: {
                return PropertiesDescriptor.getTypeDescription(property);
            }
            case 3: {
                return PropertyRelationTableModel.getRelations(relation);
            }
            case 4: {
                return property.getRegistrator();
            }
            case 5: {
                return property.getRegistrationDate();
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class EntityTypeMandatorilyRelationConverter
    implements IToStringConverter<EntityTypeMandatorilyRelation> {
        EntityTypeMandatorilyRelationConverter() {
        }

        @Override
        public final String toString(EntityTypeMandatorilyRelation entityTypeRelation) {
            String toString = entityTypeRelation.getEntityType().getCode();
            if (entityTypeRelation.isMandatory()) {
                return String.valueOf(toString) + "*";
            }
            return toString;
        }
    }
}

