/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;
import ch.systemsx.cisd.lims.client.utilities.SampleDescriptor;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SampleBasicTableModel
extends ModalTableModel {
    private static final int COLUMN_COUNT = 12;
    private final Sample[] samples;
    private final String header;

    public SampleBasicTableModel(Sample[] samples, String header, boolean prettyMode) {
        super(prettyMode);
        this.samples = samples;
        this.header = header;
    }

    private static final String getSampleTypeCode(Sample sample) {
        return sample.getSampleType().getCode();
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return Person.class;
            }
            case 4: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public final int getColumnCount() {
        return 12;
    }

    @Override
    public final String getHeader() {
        return this.header;
    }

    @Override
    public final int getRowCount() {
        return this.samples.length;
    }

    @Override
    public final String getColumnName(int columnIndex) {
        return this.getColumnDesc(columnIndex).getName(this.prettyMode);
    }

    private final FieldName getColumnDesc(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.CODE;
            }
            case 1: {
                return FieldName.TYPE_CODE;
            }
            case 2: {
                return FieldName.INVALIDATED;
            }
            case 3: {
                return FieldName.REGISTRATOR;
            }
            case 4: {
                return FieldName.REGISTRATION_DATE;
            }
            case 5: {
                return FieldName.CONTROL_LAYOUT;
            }
            case 6: {
                return FieldName.MASTER_PLATE;
            }
            case 7: {
                return FieldName.MASTER_CONTROL_LAYOUT;
            }
            case 8: {
                return FieldName.DILUTION_PLATE;
            }
            case 9: {
                return FieldName.DILUTION_CONTROL_LAYOUT;
            }
            case 10: {
                return FieldName.CELL_PLATE;
            }
            case 11: {
                return FieldName.CELL_CONTROL_LAYOUT;
            }
        }
        throw new IllegalArgumentException("invalid table column index " + columnIndex);
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        this.assertColumnIndex(columnIndex);
        Sample sample = this.samples[rowIndex];
        switch (columnIndex) {
            case 0: {
                return SampleDescriptor.getSampleCode(sample);
            }
            case 1: {
                return SampleBasicTableModel.getSampleTypeCode(sample);
            }
            case 2: {
                if (sample.getInvalidation() != null) {
                    return true;
                }
                return false;
            }
            case 3: {
                return sample.getRegistrator();
            }
            case 4: {
                return sample.getRegistrationDate();
            }
            case 5: {
                return SampleDescriptor.getControlLayoutCode(sample);
            }
            case 6: {
                return SampleDescriptor.getMasterPlateCode(sample);
            }
            case 7: {
                return SampleDescriptor.getMasterPlateControlLayout(sample);
            }
            case 8: {
                return SampleDescriptor.getDilutionPlateCode(sample);
            }
            case 9: {
                return SampleDescriptor.getDilutionPlateControlLayout(sample);
            }
            case 10: {
                return SampleDescriptor.getCellPlateCode(sample);
            }
            case 11: {
                return SampleDescriptor.getCellPlateControlLayout(sample);
            }
        }
        throw new IllegalArgumentException("invalid table column index " + columnIndex);
    }
}

