/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.Experiment;
import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.ListSet;
import ch.systemsx.cisd.lims.base.Procedure;
import ch.systemsx.cisd.lims.base.Project;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.client.model.ListSetBasedTableModel;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;
import ch.systemsx.cisd.lims.client.model.SampleBasicTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SampleTableModel
extends ModalTableModel {
    private static final int EXTRA_FIXED_COLUMN_COUNT = 2;
    private final ListSetBasedTableModel listSetBasedTableModel;
    private final SampleBasicTableModel basicTable;
    private final Sample[] samples;

    public SampleTableModel(Sample[] samples, String header, boolean prettyMode) {
        super(prettyMode);
        this.basicTable = new SampleBasicTableModel(samples, header, prettyMode);
        this.samples = samples;
        this.listSetBasedTableModel = new ListSetBasedTableModel(header, SampleTableModel.createPropertiesListSet(samples, prettyMode));
    }

    private int getLocalColumnIndex(int columnIndex) {
        return columnIndex - this.basicTable.getColumnCount();
    }

    private static final ListSet createPropertiesListSet(Sample[] samples, boolean prettyMode) {
        ListSet table = new ListSet();
        Sample[] sampleArray = samples;
        int n = samples.length;
        int n2 = 0;
        while (n2 < n) {
            Sample sample = sampleArray[n2];
            SimpleEntityProperty[] properties = sample.getProperties();
            if (properties != null) {
                SimpleEntityProperty[] simpleEntityPropertyArray = properties;
                int n3 = properties.length;
                int n4 = 0;
                while (n4 < n3) {
                    SimpleEntityProperty property = simpleEntityPropertyArray[n4];
                    String name = prettyMode ? property.getUserLabel() : property.getCode();
                    table.addToList(name, property.getUntypedValue());
                    ++n4;
                }
            }
            ++n2;
        }
        return table;
    }

    private static final String getExperimentCode(Sample sample) {
        Experiment experiment = SampleTableModel.tryGetExperiment(sample);
        return experiment == null ? null : experiment.getCode();
    }

    private static final Experiment tryGetExperiment(Sample sample) {
        Procedure procedure = sample.getProcedure();
        if (procedure != null) {
            return procedure.getExperiment();
        }
        return null;
    }

    private static final String getProjectCode(Sample sample) {
        Project project;
        Experiment experiment = SampleTableModel.tryGetExperiment(sample);
        if (experiment != null && (project = experiment.getProject()) != null) {
            return project.getCode();
        }
        return null;
    }

    private int getFixedColumnsCount() {
        return this.basicTable.getColumnCount() + 2;
    }

    private int getPropertiesColumnIndex(int localColumnIndex) {
        return localColumnIndex - 2;
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        this.assertColumnIndex(columnIndex);
        if (columnIndex < this.basicTable.getColumnCount()) {
            return this.basicTable.getColumnClass(columnIndex);
        }
        int localColumnIndex = this.getLocalColumnIndex(columnIndex);
        if (localColumnIndex < 2) {
            return String.class;
        }
        return this.listSetBasedTableModel.getColumnClass(this.getPropertiesColumnIndex(localColumnIndex));
    }

    @Override
    public final String getColumnName(int columnIndex) {
        this.assertColumnIndex(columnIndex);
        if (columnIndex < this.basicTable.getColumnCount()) {
            return this.basicTable.getColumnName(columnIndex);
        }
        int localColumnIndex = this.getLocalColumnIndex(columnIndex);
        if (localColumnIndex < 2) {
            return this.getFixedColumnName(localColumnIndex);
        }
        return this.listSetBasedTableModel.getColumnName(this.getPropertiesColumnIndex(localColumnIndex));
    }

    private String getFixedColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.EXPERIMENT.getName(this.prettyMode);
            }
            case 1: {
                return FieldName.PROJECT.getName(this.prettyMode);
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    @Override
    public final int getColumnCount() {
        return this.listSetBasedTableModel.getColumnCount() + this.getFixedColumnsCount();
    }

    @Override
    public final String getHeader() {
        return this.basicTable.getHeader();
    }

    @Override
    public final int getRowCount() {
        return this.basicTable.getRowCount();
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        this.assertColumnIndex(columnIndex);
        if (columnIndex < this.basicTable.getColumnCount()) {
            return this.basicTable.getValueAt(rowIndex, columnIndex);
        }
        Sample sample = this.samples[rowIndex];
        int localColumnIndex = this.getLocalColumnIndex(columnIndex);
        switch (localColumnIndex) {
            case 0: {
                return SampleTableModel.getExperimentCode(sample);
            }
            case 1: {
                return SampleTableModel.getProjectCode(sample);
            }
        }
        return this.listSetBasedTableModel.getValueAt(rowIndex, this.getPropertiesColumnIndex(localColumnIndex));
    }
}

