/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.base.VocabularyTerm;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;
import java.util.Arrays;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VocabularyTermTableModel
extends ModalTableModel {
    private final VocabularyTerm[] vocabularyTerms;

    public VocabularyTermTableModel(VocabularyTerm[] vocabularyTerms, boolean prettyMode) {
        super(prettyMode);
        this.vocabularyTerms = vocabularyTerms;
        Arrays.sort(vocabularyTerms);
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return Person.class;
            }
            case 2: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public final int getColumnCount() {
        return 3;
    }

    @Override
    public final String getHeader() {
        return "Vocabulary Terms";
    }

    @Override
    public final int getRowCount() {
        return this.vocabularyTerms.length;
    }

    @Override
    public final String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.CODE.getName(this.prettyMode);
            }
            case 1: {
                return FieldName.REGISTRATOR.getName(this.prettyMode);
            }
            case 2: {
                return FieldName.REGISTRATION_DATE.getName(this.prettyMode);
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        VocabularyTerm vocabularyTerm = this.vocabularyTerms[rowIndex];
        switch (columnIndex) {
            case 0: {
                return vocabularyTerm.getCode();
            }
            case 1: {
                return vocabularyTerm.getRegistrator();
            }
            case 2: {
                return vocabularyTerm.getRegistrationDate();
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }
}

