/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.utilities;

import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.client.output.IOutputPrinter;
import org.apache.commons.lang.StringUtils;

public final class PersonDescriptor {
    private PersonDescriptor() {
    }

    private static final void checkPerson(Person person) {
        assert (person != null) : "Given person can not be null.";
    }

    public static final void printKeyValueRegisterer(IOutputPrinter printer, Person person, boolean prettyMode) {
        assert (printer != null);
        PersonDescriptor.checkPerson(person);
        printer.printKeyValuePair(FieldName.REGISTRATOR_LOGIN.getName(prettyMode), person.getUserId());
        printer.printKeyValuePair(FieldName.REGISTRATOR_NAME.getName(prettyMode), PersonDescriptor.getUserNameForKeyValuePair(person));
        printer.printKeyValuePair(FieldName.REGISTRATOR_EMAIL.getName(prettyMode), person.getEmail());
    }

    public static final void printKeyValueInvalidator(IOutputPrinter printer, Person person, boolean prettyMode) {
        assert (printer != null);
        PersonDescriptor.checkPerson(person);
        printer.printKeyValuePair(FieldName.INVALIDATOR_LOGIN.getName(prettyMode), person.getUserId());
        printer.printKeyValuePair(FieldName.INVALIDATOR_NAME.getName(prettyMode), PersonDescriptor.getUserNameForKeyValuePair(person));
        printer.printKeyValuePair(FieldName.INVALIDATOR_EMAIL.getName(prettyMode), person.getEmail());
    }

    private static String getUserNameForKeyValuePair(Person person) {
        String firstName;
        PersonDescriptor.checkPerson(person);
        StringBuilder builder = new StringBuilder();
        String lastName = person.getLastName();
        if (!StringUtils.isBlank(lastName)) {
            builder.append(lastName);
        }
        if (!StringUtils.isBlank(firstName = person.getFirstName())) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(firstName);
        }
        return builder.toString();
    }

    public static final String getShortDescription(Person person) {
        String firstName;
        PersonDescriptor.checkPerson(person);
        StringBuilder builder = new StringBuilder();
        String lastName = person.getLastName();
        if (!StringUtils.isBlank(lastName)) {
            builder.append(lastName);
        }
        if (!StringUtils.isBlank(firstName = person.getFirstName())) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(firstName);
        }
        if (builder.length() != 0) {
            builder.append(' ');
        }
        builder.append('[');
        builder.append(person.getUserId());
        builder.append(']');
        return builder.toString();
    }
}

