/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.utilities;

import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.client.output.IOutputPrinter;

public class SampleDescriptor {
    public static void printKeyValueSampleHierarchy(IOutputPrinter printer, boolean prettyMode, Sample sample) {
        SampleDescriptor.print(FieldName.CONTROL_LAYOUT, SampleDescriptor.getControlLayoutCode(sample), printer, prettyMode);
        SampleDescriptor.print(FieldName.MASTER_PLATE, SampleDescriptor.getMasterPlateCode(sample), printer, prettyMode);
        SampleDescriptor.print(FieldName.MASTER_CONTROL_LAYOUT, SampleDescriptor.getMasterPlateControlLayout(sample), printer, prettyMode);
        SampleDescriptor.print(FieldName.DILUTION_PLATE, SampleDescriptor.getDilutionPlateCode(sample), printer, prettyMode);
        SampleDescriptor.print(FieldName.DILUTION_CONTROL_LAYOUT, SampleDescriptor.getDilutionPlateControlLayout(sample), printer, prettyMode);
        SampleDescriptor.print(FieldName.CELL_PLATE, SampleDescriptor.getCellPlateCode(sample), printer, prettyMode);
        SampleDescriptor.print(FieldName.CELL_CONTROL_LAYOUT, SampleDescriptor.getCellPlateControlLayout(sample), printer, prettyMode);
    }

    private static void print(FieldName fieldName, String value, IOutputPrinter printer, boolean prettyMode) {
        printer.printKeyValuePair(fieldName.getName(prettyMode), value);
    }

    public static String getMasterPlateCode(Sample sample) {
        return SampleDescriptor.getSampleCode(SampleDescriptor.getMasterPlate(sample));
    }

    public static String getDilutionPlateCode(Sample sample) {
        return SampleDescriptor.getSampleCode(SampleDescriptor.tryGetDilutionPlate(sample));
    }

    public static String getCellPlateCode(Sample sample) {
        return SampleDescriptor.getSampleCode(SampleDescriptor.tryGetCellPlate(sample));
    }

    public static String getCellPlateControlLayout(Sample sample) {
        return SampleDescriptor.getControlLayoutCode(SampleDescriptor.tryGetCellPlate(sample));
    }

    public static String getDilutionPlateControlLayout(Sample sample) {
        return SampleDescriptor.getControlLayoutCode(SampleDescriptor.tryGetDilutionPlate(sample));
    }

    public static String getMasterPlateControlLayout(Sample sample) {
        return SampleDescriptor.getControlLayoutCode(SampleDescriptor.getMasterPlate(sample));
    }

    private static final Sample getMasterPlate(Sample sample) {
        return sample.getTop();
    }

    public static final String getSampleCode(Sample sampleOrNull) {
        return sampleOrNull != null ? sampleOrNull.getCode() : null;
    }

    public static final String getControlLayoutCode(Sample sampleOrNull) {
        return sampleOrNull != null ? sampleOrNull.getControlLayoutCode() : null;
    }

    private static final Sample tryGetCellPlate(Sample sample) {
        SampleTypeCode sampleType = SampleDescriptor.getSampleType(sample);
        boolean isreinfectionPlate = sampleType == SampleTypeCode.REINFECT_PLATE;
        return isreinfectionPlate ? sample.getGeneratedFrom() : null;
    }

    private static final Sample tryGetDilutionPlate(Sample sample) {
        Sample dilutionPlateOrNull = null;
        SampleTypeCode sampleType = SampleDescriptor.getSampleType(sample);
        if (sampleType == SampleTypeCode.REINFECT_PLATE) {
            dilutionPlateOrNull = sample.getGeneratedFrom().getGeneratedFrom();
        } else if (sampleType == SampleTypeCode.CELL_PLATE) {
            dilutionPlateOrNull = sample.getGeneratedFrom();
        }
        return dilutionPlateOrNull;
    }

    private static SampleTypeCode getSampleType(Sample sample) {
        String sampleTypeCode = sample.getSampleType().getCode();
        return SampleTypeCode.getSampleTypeCode(sampleTypeCode);
    }
}

