/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.LimitFilter;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.server.business.IStrategyFactory;
import ch.systemsx.cisd.lims.server.business.StrategyFactoryProvider;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.business.bo.IEntityPropertiesConverter;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dto.MaterialDTO;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractManager {
    protected final IDAOFactory daoFactory;
    protected final IBusinessObjectFactory boFactory;
    private final StrategyFactoryProvider strategyProvider;

    AbstractManager(IDAOFactory daoFactory, StrategyFactoryProvider strategyProvider, IBusinessObjectFactory boFactory) {
        assert (daoFactory != null) : "Undefined DAO Factory";
        assert (strategyProvider != null) : "Undefined Strategy Factory Provider";
        assert (boFactory != null) : "Undefined Business Object Factory";
        this.boFactory = boFactory;
        this.daoFactory = daoFactory;
        this.strategyProvider = strategyProvider;
    }

    static final <T> List<T> subList(LimitFilter limitFilter, List<T> list) {
        assert (limitFilter != null);
        assert (list != null);
        int limit = limitFilter.getLimit();
        int size = list.size();
        int fromIndex = limitFilter.getStart();
        assert (fromIndex <= size);
        int toIndex = limit > -1 ? Math.min(fromIndex + limit, size) : size;
        return list.subList(fromIndex, toIndex);
    }

    protected final IStrategyFactory getStrategyFactory(long groupId) {
        return this.strategyProvider.getFactory(groupId);
    }

    protected BeanUtils.Converter createMaterialPropertiesConverter() {
        return new MaterialConverter();
    }

    class MaterialConverter
    implements BeanUtils.Converter {
        private final IEntityPropertiesConverter converter;

        public MaterialConverter() {
            this.converter = AbstractManager.this.boFactory.createEntityPropertiesConverter(EntityKind.MATERIAL);
        }

        public SimpleEntityProperty[] convertToProperties(MaterialDTO entity) {
            return this.converter.convertProperties(entity);
        }
    }
}

